/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidLevel;

public final class Headgroup {
    public static HashMap<String, LipidCategory> StringCategory = new HashMap();
    public static HashMap<String, Integer> StringClass = new HashMap();
    public static HashMap<Integer, String> ClassString = new HashMap();
    public static HashSet<String> exceptionHeadgroups = new HashSet<String>(Arrays.asList("Cer", "SPB"));
    private String headgroup;
    private LipidCategory lipidCategory;
    private int lipidClass;
    private boolean useHeadgroup;
    private ArrayList<HeadgroupDecorator> decorators;
    private boolean spException;
    public static final Map<LipidCategory, String> CategoryString = Map.ofEntries(Map.entry(LipidCategory.NO_CATEGORY, "NO_CATEGORY"), Map.entry(LipidCategory.UNDEFINED, "UNDEFINED"), Map.entry(LipidCategory.GL, "GL"), Map.entry(LipidCategory.GP, "GP"), Map.entry(LipidCategory.SP, "SP"), Map.entry(LipidCategory.ST, "ST"), Map.entry(LipidCategory.FA, "FA"), Map.entry(LipidCategory.SL, "SL"));

    public Headgroup(String _headgroup) {
        this(_headgroup, null, false);
    }

    public Headgroup(String _headgroup, ArrayList<HeadgroupDecorator> _decorators, boolean _use_headgroup) {
        this.headgroup = _headgroup;
        this.lipidCategory = Headgroup.getCategory(_headgroup);
        this.lipidClass = Headgroup.getClass(this.headgroup);
        this.useHeadgroup = _use_headgroup;
        this.decorators = _decorators != null ? _decorators : new ArrayList();
        this.spException = this.lipidCategory == LipidCategory.SP && exceptionHeadgroups.contains(((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).lipidClassName) && this.decorators.isEmpty();
    }

    public static LipidCategory getCategory(String _headgroup) {
        if (StringCategory.isEmpty()) {
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                LipidCategory category = lipid_class.lipidCategory;
                lipid_class.synonyms.forEach(hg -> StringCategory.put((String)hg, category));
            }
        }
        return StringCategory.containsKey(_headgroup) ? StringCategory.get(_headgroup) : LipidCategory.UNDEFINED;
    }

    public static int getClass(String _headgroup) {
        if (StringClass.isEmpty()) {
            int l_class = 0;
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                for (String hg : lipid_class.synonyms) {
                    StringClass.put(hg, l_class);
                }
                ++l_class;
            }
        }
        return StringClass.containsKey(_headgroup) ? StringClass.get(_headgroup) : 0;
    }

    public static String getClassString(int _lipid_class) {
        if (ClassString.isEmpty()) {
            int l_class = 0;
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                ClassString.put(l_class++, lipid_class.synonyms.get(0));
            }
        }
        return ClassString.containsKey(_lipid_class) ? ClassString.get(_lipid_class) : "UNDEFINED";
    }

    public String getClassName() {
        return ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).lipidClassName;
    }

    public static String getCategoryString(LipidCategory _lipid_category) {
        return CategoryString.get((Object)_lipid_category);
    }

    public String getLipidString(LipidLevel level) {
        String hgs;
        if (level == LipidLevel.CATEGORY) {
            return Headgroup.getCategoryString(this.lipidCategory);
        }
        String string = hgs = this.useHeadgroup ? this.headgroup : Headgroup.getClassString(this.lipidClass);
        if (level == LipidLevel.CLASS) {
            return hgs;
        }
        StringBuilder headgoup_string = new StringBuilder();
        if (!LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level)) {
            ArrayList<HeadgroupDecorator> decoratorsTmp = new ArrayList<HeadgroupDecorator>();
            for (HeadgroupDecorator hgd : this.decorators) {
                if (hgd.isSuffix()) continue;
                decoratorsTmp.add((HeadgroupDecorator)hgd.copy());
            }
            Collections.sort(decoratorsTmp);
            for (int i = decoratorsTmp.size() - 1; i > 0; --i) {
                HeadgroupDecorator hge = (HeadgroupDecorator)decoratorsTmp.get(i);
                HeadgroupDecorator hgeBefore = (HeadgroupDecorator)decoratorsTmp.get(i - 1);
                if (!hge.getName().equals(hgeBefore.getName())) continue;
                hgeBefore.setCount(hgeBefore.getCount() + hge.getCount());
                decoratorsTmp.remove(i);
            }
            for (HeadgroupDecorator hge : decoratorsTmp) {
                headgoup_string.append(hge.toString(level));
            }
        } else {
            for (HeadgroupDecorator hgd : this.decorators) {
                if (hgd.isSuffix()) continue;
                headgoup_string.append(hgd.toString(level)).append("-");
            }
        }
        headgoup_string.append(hgs);
        for (HeadgroupDecorator hgd : this.decorators) {
            if (!hgd.isSuffix()) continue;
            headgoup_string.append(hgd.toString(level));
        }
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level) && this.lipidCategory == LipidCategory.SP && !this.spException) {
            headgoup_string.append("(1)");
        }
        return headgoup_string.toString();
    }

    @JsonIgnore
    public ElementTable getElements() {
        if (this.useHeadgroup || LipidClasses.getInstance().size() <= this.lipidClass) {
            throw new ConstraintViolationException("Element table cannot be computed for lipid '" + this.headgroup + "'");
        }
        ElementTable elements = ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).elements.copy();
        this.decorators.forEach(hgd -> elements.add(hgd.computeAndCopyElements(), hgd.count));
        return elements;
    }

    public String getHeadgroup() {
        return this.headgroup;
    }

    public void setHeadgroup(String headgroup) {
        this.headgroup = headgroup;
    }

    public LipidCategory getLipidCategory() {
        return this.lipidCategory;
    }

    public void setLipidCategory(LipidCategory lipidCategory) {
        this.lipidCategory = lipidCategory;
    }

    public int getLipidClass() {
        return this.lipidClass;
    }

    public void setLipidClass(int lipidClass) {
        this.lipidClass = lipidClass;
    }

    @JsonIgnore
    public boolean isUseHeadgroup() {
        return this.useHeadgroup;
    }

    public void setUseHeadgroup(boolean useHeadgroup) {
        this.useHeadgroup = useHeadgroup;
    }

    @JsonIgnore
    public boolean isSpException() {
        return this.spException;
    }

    public void setSpException(boolean spException) {
        this.spException = spException;
    }

    @JsonIgnore
    public ArrayList<HeadgroupDecorator> getDecorators() {
        return this.decorators;
    }

    public void setDecorators(ArrayList<HeadgroupDecorator> decorators) {
        this.decorators = decorators;
    }
}

