/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import org.lifstools.jgoslin.domain.ConstraintViolationException;

final class Bitfield {
    private final long[] field;
    private final int length;
    private final int field_len;
    private int num_size;
    private int iter = 0;
    private int pos = 0;

    Bitfield(int _length) {
        this.length = _length;
        this.field_len = 1 + (this.length + 1 >>> 6);
        this.field = new long[this.field_len];
        this.num_size = 0;
        for (int i = 0; i < this.field_len; ++i) {
            this.field[i] = 0L;
        }
    }

    void add(int pos) {
        if (!this.find(pos)) {
            int n = pos >>> 6;
            this.field[n] = this.field[n] | 1L << (pos & 0x3F);
            ++this.num_size;
        }
    }

    boolean find(int pos) {
        return (this.field[pos >>> 6] >>> (pos & 0x3F) & 1L) == 1L;
    }

    boolean isNotSet(int pos) {
        return (this.field[pos >>> 6] >>> (pos & 0x3F) & 1L) == 0L;
    }

    static String printBitfield(long l) {
        StringBuilder sb = new StringBuilder();
        for (int i = 63; i >= 0; --i) {
            sb.append(l >>> i & 1L);
        }
        return sb.toString();
    }

    void resetIterator() {
        this.iter = 0;
        this.pos = -1;
    }

    boolean hasNext() {
        return this.iter < this.num_size;
    }

    int next() {
        ++this.pos;
        if (this.pos >= this.length) {
            throw new ConstraintViolationException("Bitfield out of range at pos=" + this.pos + " for length=" + this.length);
        }
        int field_pos = this.pos >>> 6;
        long field_bits = this.field[field_pos] & ((1L << (int)((long)(this.pos & 0x3F))) - 1L ^ 0xFFFFFFFFFFFFFFFFL);
        do {
            if (field_bits != 0L) {
                this.pos = (field_pos << 6) + Long.numberOfTrailingZeros(field_bits & -field_bits);
                ++this.iter;
                return this.pos;
            }
            if (++field_pos >= this.field_len) continue;
            field_bits = this.field[field_pos];
        } while (field_pos < this.field_len);
        throw new ConstraintViolationException("Bitfield out of range at pos=" + this.pos + " for field_len=" + this.field_len);
    }
}

