/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.Collection;
import java.util.Collections;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidStructureDefined;

public class LipidFullStructure
extends LipidStructureDefined {
    public LipidFullStructure(Headgroup _headgroup, KnownFunctionalGroups knownFunctionalGroups) {
        this(_headgroup, Collections.emptyList(), knownFunctionalGroups);
    }

    public LipidFullStructure(Headgroup _headgroup, Collection<FattyAcid> _fa, KnownFunctionalGroups knownFunctionalGroups) {
        super(_headgroup, _fa, knownFunctionalGroups);
        this.info.setLevel(LipidLevel.FULL_STRUCTURE);
    }

    @Override
    public LipidLevel getLipidLevel() {
        return LipidLevel.FULL_STRUCTURE;
    }

    @Override
    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    @Override
    public String getLipidString(LipidLevel level) {
        switch (level) {
            case NO_LEVEL: 
            case FULL_STRUCTURE: {
                return super.buildLipidSubspeciesName(LipidLevel.FULL_STRUCTURE);
            }
            case STRUCTURE_DEFINED: 
            case SN_POSITION: 
            case MOLECULAR_SPECIES: 
            case SPECIES: 
            case CATEGORY: 
            case CLASS: {
                return super.getLipidString(level);
            }
        }
        throw new IllegalArgumentException("LipidFullStructure does not know how to create a lipid string for level " + level.toString());
    }
}

