/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.LipidBaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class GoslinParserEventHandler
extends LipidBaseParserEventHandler {
    private int dbPosition;
    private String dbCistrans;
    private char plasmalogen;
    private String mediatorFunction;
    private final ArrayList<Integer> mediatorFunctionPositions = new ArrayList();
    private boolean mediatorSuffix;
    private Element heavyElement;
    private int heavyElementNumber;
    private static final Map<String, Integer> MEDIATOR_FA = Map.of("H", 17, "O", 18, "E", 20, "Do", 22);
    private static final Map<String, Integer> MEDIATOR_DB = Map.of("M", 1, "D", 2, "Tr", 3, "T", 4, "P", 5, "H", 6);

    public GoslinParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        super(knownFunctionalGroups);
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::buildLipid), Map.entry("hg_cl_pre_event", this::setHeadGroupName), Map.entry("hg_mlcl_pre_event", this::setHeadGroupName), Map.entry("hg_pl_pre_event", this::setHeadGroupName), Map.entry("hg_lpl_pre_event", this::setHeadGroupName), Map.entry("hg_lsl_pre_event", this::setHeadGroupName), Map.entry("hg_so_lsl_pre_event", this::setHeadGroupName), Map.entry("hg_dsl_pre_event", this::setHeadGroupName), Map.entry("st_pre_event", this::setHeadGroupName), Map.entry("hg_ste_pre_event", this::setHeadGroupName), Map.entry("hg_stes_pre_event", this::setHeadGroupName), Map.entry("hg_mgl_pre_event", this::setHeadGroupName), Map.entry("hg_dgl_pre_event", this::setHeadGroupName), Map.entry("hg_sgl_pre_event", this::setHeadGroupName), Map.entry("hg_tgl_pre_event", this::setHeadGroupName), Map.entry("hg_dlcl_pre_event", this::setHeadGroupName), Map.entry("hg_sac_di_pre_event", this::setHeadGroupName), Map.entry("hg_sac_f_pre_event", this::setHeadGroupName), Map.entry("hg_tpl_pre_event", this::setHeadGroupName), Map.entry("gl_species_pre_event", this::setSpeciesLevel), Map.entry("pl_species_pre_event", this::setSpeciesLevel), Map.entry("sl_species_pre_event", this::setSpeciesLevel), Map.entry("fa2_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa3_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("fa4_unsorted_pre_event", this::setMolecularSubspeciesLevel), Map.entry("slbpa_pre_event", this::setMolecularSubspeciesLevel), Map.entry("dlcl_pre_event", this::setMolecularSubspeciesLevel), Map.entry("mlcl_pre_event", this::setMolecularSubspeciesLevel), Map.entry("lcb_pre_event", this::newLcb), Map.entry("lcb_post_event", this::cleanLcb), Map.entry("fa_pre_event", this::newFa), Map.entry("fa_post_event", this::appendFa), Map.entry("db_single_position_pre_event", this::setIsomericLevel), Map.entry("db_single_position_post_event", this::addDbPosition), Map.entry("db_position_number_pre_event", this::addDbPositionNumber), Map.entry("cistrans_pre_event", this::addCistrans), Map.entry("ether_pre_event", this::addEther), Map.entry("old_hydroxyl_pre_event", this::addOldHydroxyl), Map.entry("db_count_pre_event", this::addDoubleBonds), Map.entry("carbon_pre_event", this::addCarbon), Map.entry("hydroxyl_pre_event", this::addHydroxyl), Map.entry("adduct_info_pre_event", this::newAdduct), Map.entry("adduct_pre_event", this::addAdduct), Map.entry("charge_pre_event", this::addCharge), Map.entry("charge_sign_pre_event", this::addChargeSign), Map.entry("lpl_pre_event", this::setMolecularSubspeciesLevel), Map.entry("plasmalogen_pre_event", this::setPlasmalogen), Map.entry("mediator_pre_event", this::setMediator), Map.entry("mediator_post_event", this::addMediator), Map.entry("unstructured_mediator_pre_event", this::setUnstructuredMediator), Map.entry("trivial_mediator_pre_event", this::setTrivialMediator), Map.entry("mediator_carbon_pre_event", this::setMediatorCarbon), Map.entry("mediator_db_pre_event", this::setMediatorDB), Map.entry("mediator_mono_functions_pre_event", this::setMediatorFunction), Map.entry("mediator_di_functions_pre_event", this::setMediatorFunction), Map.entry("mediator_position_pre_event", this::setMediatorFunctionPosition), Map.entry("mediator_functional_group_post_event", this::addMediatorFunction), Map.entry("mediator_suffix_pre_event", this::addMediatorSuffix), Map.entry("mediator_tetranor_pre_event", this::setMediatorTetranor), Map.entry("isotope_pair_pre_event", this::newAdduct), Map.entry("isotope_element_pre_event", this::setHeavyDElement), Map.entry("isotope_number_pre_event", this::setHeavyDNumber), Map.entry("heavy_pre_event", this::newAdduct), Map.entry("adduct_heavy_element_pre_event", this::setHeavyElement), Map.entry("adduct_heavy_number_pre_event", this::setHeavyNumber), Map.entry("adduct_heavy_component_post_event", this::addHeavyComponent));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize GoslinParserEventHandler");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.headGroup = "";
        this.lcb = null;
        this.faList.clear();
        this.currentFa = null;
        this.adduct = null;
        this.dbPosition = 0;
        this.dbCistrans = "";
        this.plasmalogen = '\u0000';
        this.mediatorFunction = "";
        this.mediatorFunctionPositions.clear();
        this.mediatorSuffix = false;
        this.useHeadGroup = false;
        this.headgroupDecorators.clear();
        this.heavyElement = Element.C;
        this.heavyElementNumber = 0;
    }

    private void setHeadGroupName(TreeNode node) {
        this.headGroup = node.getText();
    }

    private void setSpeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
    }

    private void setIsomericLevel(TreeNode node) {
        this.dbPosition = 0;
        this.dbCistrans = "";
    }

    private void addDbPosition(TreeNode node) {
        if (this.currentFa != null) {
            this.currentFa.getDoubleBonds().getDoubleBondPositions().put(this.dbPosition, this.dbCistrans);
            if (!this.dbCistrans.equals("E") && !this.dbCistrans.equals("Z")) {
                this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
            }
        }
    }

    private void setPlasmalogen(TreeNode node) {
        this.plasmalogen = node.getText().toUpperCase().charAt(0);
    }

    private void addDbPositionNumber(TreeNode node) {
        this.dbPosition = Integer.valueOf(node.getText());
    }

    private void addCistrans(TreeNode node) {
        this.dbCistrans = node.getText();
    }

    private void setMolecularSubspeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
    }

    private void newFa(TreeNode node) {
        LipidFaBondType lipid_FA_bond_type = LipidFaBondType.ESTER;
        this.currentFa = new FattyAcid("FA", 2, null, null, lipid_FA_bond_type, this.knownFunctionalGroups);
    }

    private void newLcb(TreeNode node) {
        this.lcb = new FattyAcid("LCB", this.knownFunctionalGroups);
        this.lcb.setType(LipidFaBondType.LCB_REGULAR);
        this.currentFa = this.lcb;
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
    }

    private void cleanLcb(TreeNode node) {
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.currentFa = null;
    }

    private void appendFa(TreeNode node) {
        if (this.currentFa.getLipidFaBondType() == LipidFaBondType.ETHER_UNSPECIFIED) {
            throw new LipidException("Lipid with unspecified ether bond cannot be treated properly.");
        }
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        if (this.currentFa.getDoubleBonds().getNumDoubleBonds() < 0) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        this.faList.add(this.currentFa);
        if (this.headGroup.compareTo("Sa") == 0 || this.headGroup.compareTo("So") == 0 || this.headGroup.compareTo("S1P") == 0 || this.headGroup.compareTo("Sa1P") == 0) {
            FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
            if (this.headGroup.compareTo("Sa") == 0 || this.headGroup.compareTo("So") == 0) {
                functional_group.setCount(2);
                this.currentFa.setLipidFaBondType(LipidFaBondType.LCB_EXCEPTION);
            } else {
                functional_group.setCount(1);
                this.currentFa.setLipidFaBondType(LipidFaBondType.LCB_REGULAR);
            }
            if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
                this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
            }
            this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
        }
        this.currentFa = null;
    }

    private void buildLipid(TreeNode node) {
        if (this.lcb != null) {
            this.faList.add(0, this.lcb);
            this.lcb = null;
            this.currentFa = null;
        }
        if (this.plasmalogen != '\u0000' && this.faList.size() > 0 && this.lcb == null) {
            ((FattyAcid)this.faList.get(0)).setLipidFaBondType(this.plasmalogen == 'O' ? LipidFaBondType.ETHER_PLASMANYL : LipidFaBondType.ETHER_PLASMENYL);
        }
        Headgroup headgroup = this.prepareHeadgroupAndChecks();
        LipidAdduct lipid = new LipidAdduct(this.assembleLipid(headgroup), this.adduct);
        this.content = lipid;
    }

    private void addEther(TreeNode node) {
        String ether = node.getText();
        if (ether.equals("a")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMANYL);
        } else if (ether.equals("p")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMENYL);
            this.currentFa.getDoubleBonds().setNumDoubleBonds(Math.max(0, this.currentFa.getDoubleBonds().getNumDoubleBonds() - 1));
        }
        this.plasmalogen = '\u0000';
    }

    private void addOldHydroxyl(TreeNode node) {
        String old_hydroxyl = node.getText();
        int num_h = 0;
        if (old_hydroxyl.equals("d")) {
            num_h = 2;
        } else if (old_hydroxyl.equals("t")) {
            num_h = 3;
        }
        if (this.spRegularLcb()) {
            --num_h;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
    }

    private void addDoubleBonds(TreeNode node) {
        this.currentFa.getDoubleBonds().setNumDoubleBonds(Integer.valueOf(node.getText()));
    }

    private void addCarbon(TreeNode node) {
        this.currentFa.setNumCarbon(Integer.valueOf(node.getText()));
    }

    private void addHydroxyl(TreeNode node) {
        int num_h = Integer.valueOf(node.getText());
        if (this.spRegularLcb()) {
            --num_h;
        }
        if (num_h <= 0) {
            return;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
    }

    private void newAdduct(TreeNode node) {
        if (this.adduct == null) {
            this.adduct = new Adduct("", "");
        }
    }

    private void addAdduct(TreeNode node) {
        this.adduct.setAdductString(node.getText());
    }

    private void addCharge(TreeNode node) {
        this.adduct.setCharge(Integer.valueOf(node.getText()));
    }

    private void addChargeSign(TreeNode node) {
        String sign = node.getText();
        if (sign.equals("+")) {
            this.adduct.setChargeSign(1);
        } else if (sign.equals("-")) {
            this.adduct.setChargeSign(-1);
        }
        if (this.adduct.getCharge() == 0) {
            this.adduct.setCharge(1);
        }
    }

    private void setMediator(TreeNode node) {
        this.headGroup = "FA";
        this.currentFa = new FattyAcid("FA", this.knownFunctionalGroups);
        this.faList.add(this.currentFa);
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
    }

    private void setUnstructuredMediator(TreeNode node) {
        this.headGroup = node.getText();
        this.useHeadGroup = true;
        this.faList.clear();
    }

    private void setMediatorTetranor(TreeNode node) {
        this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() - 4);
    }

    private void setMediatorCarbon(TreeNode node) {
        this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() + MEDIATOR_FA.get(node.getText()));
    }

    private void setMediatorDB(TreeNode node) {
        this.currentFa.getDoubleBonds().setNumDoubleBonds(MEDIATOR_DB.get(node.getText()));
    }

    private void setMediatorFunction(TreeNode node) {
        this.mediatorFunction = node.getText();
    }

    private void setMediatorFunctionPosition(TreeNode node) {
        this.mediatorFunctionPositions.add(node.getInt());
    }

    private void addMediatorFunction(TreeNode node) {
        FunctionalGroup functionalGroup = null;
        String fg = "";
        if (this.mediatorFunction.equals("H")) {
            functionalGroup = this.knownFunctionalGroups.get("OH");
            fg = "OH";
            if (this.mediatorFunctionPositions.size() > 0) {
                functionalGroup.setPosition(this.mediatorFunctionPositions.get(0));
            }
        } else if (this.mediatorFunction.equals("Oxo")) {
            functionalGroup = this.knownFunctionalGroups.get("oxo");
            fg = "oxo";
            if (this.mediatorFunctionPositions.size() > 0) {
                functionalGroup.setPosition(this.mediatorFunctionPositions.get(0));
            }
        } else if (this.mediatorFunction.equals("Hp")) {
            functionalGroup = this.knownFunctionalGroups.get("OOH");
            fg = "OOH";
            if (this.mediatorFunctionPositions.size() > 0) {
                functionalGroup.setPosition(this.mediatorFunctionPositions.get(0));
            }
        } else if (this.mediatorFunction.equals("E") || this.mediatorFunction.equals("Ep")) {
            functionalGroup = this.knownFunctionalGroups.get("Ep");
            fg = "Ep";
            if (this.mediatorFunctionPositions.size() > 0) {
                functionalGroup.setPosition(this.mediatorFunctionPositions.get(0));
            }
        } else if (this.mediatorFunction.equals("DH") || this.mediatorFunction.equals("DiH") || this.mediatorFunction.equals("diH")) {
            functionalGroup = this.knownFunctionalGroups.get("OH");
            fg = "OH";
            if (this.mediatorFunctionPositions.size() > 0) {
                functionalGroup.setPosition(this.mediatorFunctionPositions.get(0));
                FunctionalGroup functionalGroup2 = this.knownFunctionalGroups.get("OH");
                functionalGroup2.setPosition(this.mediatorFunctionPositions.get(1));
                this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
                this.currentFa.getFunctionalGroupsInternal().get("OH").add(functionalGroup2);
            }
        }
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey(fg)) {
            this.currentFa.getFunctionalGroupsInternal().put(fg, new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get(fg).add(functionalGroup);
    }

    private void setTrivialMediator(TreeNode node) {
        this.headGroup = "FA";
        switch (node.getText()) {
            case "Palmitic acid": {
                this.currentFa = new FattyAcid("FA", 16, this.knownFunctionalGroups);
                break;
            }
            case "Linoleic acid": {
                this.currentFa = new FattyAcid("FA", 18, new DoubleBonds(2), this.knownFunctionalGroups);
                break;
            }
            case "AA": {
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(4), this.knownFunctionalGroups);
                break;
            }
            case "ALA": {
                this.currentFa = new FattyAcid("FA", 18, new DoubleBonds(3), this.knownFunctionalGroups);
                break;
            }
            case "EPA": {
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(5), this.knownFunctionalGroups);
                break;
            }
            case "DHA": {
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), this.knownFunctionalGroups);
                break;
            }
            case "LTB4": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(5);
                f2.setPosition(12);
                DoubleBonds db = new DoubleBonds(new TreeMap<Integer, String>(Map.of(6, "Z", 8, "E", 10, "E", 14, "Z")));
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                this.currentFa = new FattyAcid("FA", 20, db, fg, this.knownFunctionalGroups);
                break;
            }
            case "Resolvin D3": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(11);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
                break;
            }
            case "Maresin 1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(14);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
                break;
            }
            case "Resolvin D2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(16);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
                break;
            }
            case "Resolvin D5": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(7);
                f2.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
                break;
            }
            case "Resolvin D1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(7);
                f2.setPosition(8);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                this.currentFa = new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
                break;
            }
            case "TXB1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(1), fg, this.knownFunctionalGroups);
                break;
            }
            case "TXB2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxy", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
                break;
            }
            case "TXB3": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxy", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(3), fg, this.knownFunctionalGroups);
                break;
            }
            case "PGF2alpha": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
                break;
            }
            case "PGD2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("oxo");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f3))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
                break;
            }
            case "PGE2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("oxo");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f3)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
                break;
            }
            case "PGB2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, new DoubleBonds(1), fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
                break;
            }
            case "15d-PGJ2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("oxo");
                f1.setPosition(15);
                f2.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, new DoubleBonds(1), fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                this.currentFa = new FattyAcid("FA", 20, new DoubleBonds(3), fg, this.knownFunctionalGroups);
            }
        }
        this.faList.clear();
        this.faList.add(this.currentFa);
        this.mediatorSuffix = true;
    }

    private void addMediatorSuffix(TreeNode node) {
        this.mediatorSuffix = true;
    }

    private void addMediator(TreeNode node) {
        if (!this.mediatorSuffix) {
            this.currentFa.getDoubleBonds().setNumDoubleBonds(this.currentFa.getDoubleBonds().getNumDoubleBonds() - 1);
        }
    }

    private void setHeavyDElement(TreeNode node) {
        this.adduct.getHeavyElements().put(Element.H2, 1);
    }

    private void setHeavyDNumber(TreeNode node) {
        this.adduct.getHeavyElements().put(Element.H2, node.getInt());
    }

    private void setHeavyElement(TreeNode node) {
        this.heavyElement = Elements.HEAVY_ELEMENT_TABLE.get(node.getText());
        this.heavyElementNumber = 1;
    }

    private void setHeavyNumber(TreeNode node) {
        this.heavyElementNumber = node.getInt();
    }

    private void addHeavyComponent(TreeNode node) {
        this.adduct.getHeavyElements().put(this.heavyElement, (Integer)this.adduct.getHeavyElements().get((Object)this.heavyElement) + this.heavyElementNumber);
    }
}

