/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Map;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;

public final class LipidSpeciesInfo
extends FattyAcid {
    private LipidLevel level;
    public int numEthers;
    public int numSpecifiedFa;
    public int possFa;
    public int totalFa;
    public LipidFaBondType extendedClass;
    public static final String[] ETHER_PREFIX = new String[]{"", "O-", "dO-", "tO-", "eO-"};
    public int lipidClass;

    public LipidSpeciesInfo(int _lipid_class, KnownFunctionalGroups knownFunctionalGroups) {
        super("info", knownFunctionalGroups);
        this.lipidClass = _lipid_class;
        this.level = LipidLevel.NO_LEVEL;
        this.numEthers = 0;
        this.numSpecifiedFa = 0;
        this.extendedClass = LipidFaBondType.ESTER;
        this.totalFa = LipidClasses.getInstance().size() > this.lipidClass ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).maxNumFa : 0;
        this.possFa = LipidClasses.getInstance().size() > this.lipidClass ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).possibleNumFa : 0;
    }

    @Override
    public LipidSpeciesInfo copy() {
        LipidSpeciesInfo lsi = new LipidSpeciesInfo(this.lipidClass, this.knownFunctionalGroups);
        lsi.level = this.level;
        lsi.numEthers = this.numEthers;
        lsi.numSpecifiedFa = this.numSpecifiedFa;
        lsi.setPosition(this.getPosition());
        lsi.totalFa = this.totalFa;
        lsi.extendedClass = this.extendedClass;
        lsi.numCarbon = this.numCarbon;
        lsi.doubleBonds = this.doubleBonds.copy();
        lsi.lipidFaBondType = this.lipidFaBondType;
        this.functionalGroups.entrySet().stream().map(kv -> {
            lsi.functionalGroups.put((String)kv.getKey(), new ArrayList());
            return kv;
        }).forEachOrdered(kv -> ((ArrayList)kv.getValue()).forEach(func_group -> ((ArrayList)lsi.functionalGroups.get(kv.getKey())).add(func_group.copy())));
        return lsi;
    }

    @Override
    @JsonIgnore
    public ElementTable getElements() {
        ElementTable elements = super.computeAndCopyElements();
        if (this.lipidFaBondType != LipidFaBondType.LCB_EXCEPTION) {
            elements.put(Element.O, (Integer)elements.get((Object)Element.O) - (this.numEthers == 0 ? 1 : 0));
        }
        elements.put(Element.H, (Integer)elements.get((Object)Element.H) + (this.numEthers == 0 ? 1 : -1));
        return elements;
    }

    public void add(FattyAcid _fa) {
        if (_fa.lipidFaBondType == LipidFaBondType.ETHER_PLASMENYL || _fa.lipidFaBondType == LipidFaBondType.ETHER_PLASMANYL) {
            ++this.numEthers;
            this.lipidFaBondType = LipidFaBondType.ETHER_PLASMANYL;
            this.extendedClass = _fa.lipidFaBondType;
        } else if (_fa.lipidFaBondType == LipidFaBondType.LCB_EXCEPTION || _fa.lipidFaBondType == LipidFaBondType.LCB_REGULAR) {
            this.lipidFaBondType = _fa.lipidFaBondType;
        } else {
            ++this.numSpecifiedFa;
        }
        for (Map.Entry kv : _fa.functionalGroups.entrySet()) {
            if (!this.functionalGroups.containsKey(kv.getKey())) {
                this.functionalGroups.put((String)kv.getKey(), new ArrayList());
            }
            for (FunctionalGroup func_group : (ArrayList)kv.getValue()) {
                ((ArrayList)this.functionalGroups.get(kv.getKey())).add(func_group.copy());
            }
        }
        ElementTable e = _fa.computeAndCopyElements();
        this.numCarbon += ((Integer)e.get((Object)Element.C)).intValue();
        this.doubleBonds.setNumDoubleBonds(this.doubleBonds.getNumDoubleBonds() + _fa.getNDoubleBonds());
    }

    public String toString() {
        StringBuilder info_string = new StringBuilder();
        info_string.append(ETHER_PREFIX[this.numEthers]);
        info_string.append(this.numCarbon).append(":").append(this.doubleBonds.getNumDoubleBonds());
        ElementTable fg_elements = this.getFunctionalGroupElements();
        for (int i = 2; i < Elements.ELEMENT_ORDER.size(); ++i) {
            Element e = Elements.ELEMENT_ORDER.get(i);
            if ((Integer)fg_elements.get((Object)e) <= 0) continue;
            info_string.append(";").append(Elements.ELEMENT_SHORTCUT.get((Object)e));
            if ((Integer)fg_elements.get((Object)e) <= 1) continue;
            info_string.append(fg_elements.get((Object)e));
        }
        return info_string.toString();
    }

    public LipidLevel getLevel() {
        return this.level;
    }

    public void setLevel(LipidLevel level) {
        this.level = level;
    }

    public int getNumEthers() {
        return this.numEthers;
    }

    public void setNumEthers(int numEthers) {
        this.numEthers = numEthers;
    }

    public int getNumSpecifiedFa() {
        return this.numSpecifiedFa;
    }

    public void setNumSpecifiedFa(int numSpecifiedFa) {
        this.numSpecifiedFa = numSpecifiedFa;
    }

    public int getTotalFa() {
        return this.totalFa;
    }

    public void setTotalFa(int totalFa) {
        this.totalFa = totalFa;
    }

    public LipidFaBondType getExtendedClass() {
        return this.extendedClass;
    }

    public void setExtendedClass(LipidFaBondType extendedClass) {
        this.extendedClass = extendedClass;
    }

    public int getLipidClass() {
        return this.lipidClass;
    }

    public void setLipidClass(int lipidClass) {
        this.lipidClass = lipidClass;
    }
}

