/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.Parser;
import org.lifstools.jgoslin.parser.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParserEventHandler<T> {
    private static final Logger log = LoggerFactory.getLogger(BaseParserEventHandler.class);
    protected Map<String, Consumer<TreeNode>> registeredEvents = new HashMap<String, Consumer<TreeNode>>();
    protected Set<String> ruleNames = new HashSet<String>();
    protected T content = null;
    protected String errorMessage = "";

    protected BaseParserEventHandler() {
        this.registeredEvents = new HashMap<String, Consumer<TreeNode>>();
        this.ruleNames = new HashSet<String>();
    }

    protected void sanityCheck(Parser<T> parser) {
        for (String event_name : this.registeredEvents.keySet()) {
            if (!event_name.endsWith("_pre_event") && !event_name.endsWith("_post_event")) {
                throw new ConstraintViolationException("Parser event handler error: event '" + event_name + "' does not contain the suffix '_pre_event' or '_post_event'");
            }
            String rule_name = event_name.replace("_pre_event", "").replace("_post_event", "");
            if (this.ruleNames.contains(rule_name)) continue;
            throw new ConstraintViolationException("Parser event handler error: rule '" + rule_name + "' in event '" + event_name + "' is not present in the grammar" + (String)(parser != null ? " '" + parser.grammarName + "'" : ""));
        }
    }

    protected void handleEvent(String event_name, TreeNode node) {
        if (log.isDebugEnabled()) {
            String reg_event = this.registeredEvents.containsKey(event_name) ? "*" : "";
            log.debug(event_name + reg_event + ": \"" + node.getText() + "\"");
        }
        if (this.registeredEvents.containsKey(event_name)) {
            if (log.isDebugEnabled()) {
                log.debug(event_name + ": \"" + node.getText() + "\"");
            }
            try {
                this.registeredEvents.get(event_name).accept(node);
            }
            catch (Exception e) {
                throw new LipidParsingException(e.toString(), e);
            }
        }
    }

    protected abstract void resetParser(TreeNode var1);

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

