/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.cli;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.lang3.tuple.Pair;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidSpeciesInfo;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;
import org.lifstools.jgoslin.parser.FattyAcidParser;
import org.lifstools.jgoslin.parser.GoslinParser;
import org.lifstools.jgoslin.parser.HmdbParser;
import org.lifstools.jgoslin.parser.LipidMapsParser;
import org.lifstools.jgoslin.parser.LipidParser;
import org.lifstools.jgoslin.parser.Parser;
import org.lifstools.jgoslin.parser.ShorthandParser;
import org.lifstools.jgoslin.parser.SwissLipidsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmdLineParser {
    private static final Logger log = LoggerFactory.getLogger(CmdLineParser.class);
    public static final String LIPIDMAPS_CLASS_REGEXP = ".+\\[([A-Z0-9]+)\\]";
    private static final LipidClasses LIPID_CLASSES = LipidClasses.getInstance();
    private static final Map<Grammar, Parser<LipidAdduct>> parsers = new LinkedHashMap<Grammar, Parser<LipidAdduct>>();

    private static String getAppInfo() throws IOException {
        Properties p = new Properties();
        p.load(CmdLineParser.class.getResourceAsStream("/application.properties"));
        StringBuilder sb = new StringBuilder();
        String buildDate = p.getProperty("app.build.date", "no build date");
        if (!"no build date".equals(buildDate)) {
            Instant instant = Instant.ofEpochMilli(Long.parseLong(buildDate));
            buildDate = instant.toString();
        }
        sb.append("Running ").append(p.getProperty("app.name", "undefined app")).append("\n\r").append(" version: '").append(p.getProperty("app.version", "unknown version")).append("'").append("\n\r").append(" build-date: '").append(buildDate).append("'").append("\n\r").append(" scm-location: '").append(p.getProperty("scm.location", "no scm location")).append("'").append("\n\r").append(" commit: '").append(p.getProperty("scm.commit.id", "no commit id")).append("'").append("\n\r").append(" branch: '").append(p.getProperty("scm.branch", "no branch")).append("'").append("\n\r");
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        PosixParser parser = new PosixParser();
        Options options = new Options();
        String helpOpt = CmdLineParser.addHelpOption(options);
        String versionOpt = CmdLineParser.addVersionOption(options);
        String lipidNameOpt = CmdLineParser.addLipidNameInputOption(options);
        String lipidFileOpt = CmdLineParser.addLipidFileInputOption(options);
        String outputToFileOpt = CmdLineParser.addOutputToFileOption(options);
        String stripWhitespaceOpt = CmdLineParser.addStripWhitespaceOption(options);
        String grammarOpt = CmdLineParser.addGrammarOption(options);
        CommandLine line = parser.parse(options, args);
        if (line.getOptions().length == 0 || line.hasOption(helpOpt)) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("jgoslin-cli", options);
        } else if (line.hasOption(versionOpt)) {
            log.info(CmdLineParser.getAppInfo());
        } else {
            boolean toFile = false;
            if (line.hasOption(outputToFileOpt)) {
                toFile = true;
            }
            boolean stripWhitespace = false;
            if (line.hasOption(stripWhitespaceOpt)) {
                stripWhitespace = true;
            }
            Stream<String> lipidNames = Stream.empty();
            if (line.hasOption(lipidNameOpt)) {
                lipidNames = Stream.of(line.getOptionValues(lipidNameOpt));
            } else if (line.hasOption(lipidFileOpt)) {
                lipidNames = Files.lines(new File(line.getOptionValue(lipidFileOpt)).toPath()).filter(t -> !t.isEmpty());
            }
            List<Object> results = Collections.emptyList();
            results = line.hasOption(grammarOpt) ? CmdLineParser.parseNamesWith(lipidNames, Grammar.valueOf(line.getOptionValue(grammarOpt)), stripWhitespace) : CmdLineParser.parseNames(lipidNames, stripWhitespace);
            if (results.isEmpty()) {
                log.info("No results generated. Please check input file or lipid names passed on the cli!");
                System.exit(1);
            }
            if (toFile) {
                log.debug("Saving output to 'goslin-out.tsv'.");
                boolean successful = CmdLineParser.writeToFile(new File("goslin-out.tsv"), results);
                if (!successful) {
                    System.exit(1);
                }
            } else {
                log.debug("Echoing output to stdout.");
                boolean successful = CmdLineParser.writeToStdOut(results);
                if (!successful) {
                    System.exit(1);
                }
            }
        }
    }

    private static boolean writeToStdOut(List<Pair<String, List<ValidationResult>>> results) {
        boolean bl;
        StringWriter sw = new StringWriter();
        try {
            try (BufferedWriter bw = new BufferedWriter(sw);){
                CmdLineParser.writeToWriter(bw, results);
            }
            sw.flush();
            log.info(sw.toString());
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    sw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                log.error("Caught exception while trying to write validation results string!", ex);
                return false;
            }
        }
        sw.close();
        return bl;
    }

    private static boolean writeToFile(File f, List<Pair<String, List<ValidationResult>>> results) {
        boolean bl;
        block8: {
            BufferedWriter bw = Files.newBufferedWriter(f.toPath(), new OpenOption[0]);
            try {
                CmdLineParser.writeToWriter(bw, results);
                bl = true;
                if (bw == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    log.error("Caught exception while trying to write validation results to file " + String.valueOf(f), ex);
                    return false;
                }
            }
            bw.close();
        }
        return bl;
    }

    private static void initColumns(Map<String, String> map) {
        String[] columns = new String[]{"Normalized Name", "Original Name", "Grammar", "Message", "Adduct", "Sum Formula", "Mass", "Lipid Maps Category", "Lipid Maps Main Class", "Functional Class Abbr", "Functional Class Synonyms", "Level", "Total #C", "Total #DB", "Total #OH", "FA1 SN Position", "FA1 #C", "FA1 #DB", "FA1 Bond Type", "FA1 DB Positions", "FA2 SN Position", "FA2 #C", "FA2 #DB", "FA2 Bond Type", "FA2 DB Positions", "FA3 SN Position", "FA3 #C", "FA3 #DB", "FA3 Bond Type", "FA3 DB Positions", "FA4 SN Position", "FA4 #C", "FA4 #DB", "FA4 Bond Type", "FA4 DB Positions", "LCB SN Position", "LCB #C", "LCB #DB", "LCB Bond Type", "LCB DB Positions", "Lipid Shorthand CATEGORY", "Lipid Shorthand CLASS", "Lipid Shorthand SPECIES", "Lipid Shorthand MOLECULAR_SPECIES", "Lipid Shorthand SN_POSITION", "Lipid Shorthand STRUCTURE_DEFINED", "Lipid Shorthand FULL_STRUCTURE", "Lipid Shorthand COMPLETE_STRUCTURE"};
        Arrays.asList(columns).stream().forEach(t -> map.put((String)t, ""));
    }

    private static String toTable(List<Pair<String, List<ValidationResult>>> results) {
        StringBuilder sb = new StringBuilder();
        LinkedHashSet keys = new LinkedHashSet();
        List validationResults = results.stream().map(t -> (List)t.getValue()).flatMap(Collection::stream).toList();
        List<Map> entries = validationResults.stream().map(t -> {
            LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
            CmdLineParser.initColumns(m);
            m.put("Normalized Name", Optional.ofNullable(t.canonicalName).orElse(""));
            m.put("Original Name", t.lipidName);
            m.put("Grammar", t.grammar.name());
            m.put("Message", t.messages.stream().collect(Collectors.joining(" | ")));
            if (t.lipidAdduct != null) {
                m.put("Adduct", t.lipidAdduct.getAdduct() == null ? "" : t.lipidAdduct.getAdduct().getLipidString());
                try {
                    m.put("Sum Formula", t.lipidAdduct.getSumFormula());
                }
                catch (NullPointerException | ConstraintViolationException cve) {
                    log.debug("Could not calculate sum formula for lipid {}", (Object)t.lipidName);
                    log.error("Exception:", cve);
                    m.put("Sum Formula", "");
                }
                try {
                    m.put("Mass", String.format(Locale.US, "%.4f", t.lipidAdduct.getMass()));
                }
                catch (NullPointerException | ConstraintViolationException cve) {
                    log.debug("Could not calculate mass for lipid {}", (Object)t.lipidName);
                    log.error("Exception:", cve);
                    m.put("Mass", "");
                }
                m.put("Lipid Maps Category", t.lipidAdduct.getLipid().getHeadGroup().getLipidCategory().getFullName() + " [" + t.lipidAdduct.getLipid().getHeadGroup().getLipidCategory().name() + "]");
                LipidClassMeta lclass = (LipidClassMeta)LIPID_CLASSES.get(t.lipidAdduct.getLipid().getInfo().lipidClass);
                m.put("Lipid Maps Main Class", lclass.description);
                String lclassAbbr = CmdLineParser.getLipidMapsClassAbbreviation(lclass.description);
                m.put("Functional Class Abbr", lclassAbbr);
                m.put("Functional Class Synonyms", "[" + lclass.synonyms.stream().collect(Collectors.joining(", ")) + "]");
                m.put("Level", t.level.name());
                m.put("Total #C", "" + t.lipidSpeciesInfo.getNumCarbon());
                m.put("Total #DB", "" + t.lipidSpeciesInfo.getDoubleBonds().getNumDoubleBonds());
                Map<String, ArrayList<FunctionalGroup>> functionalGroups = t.lipidSpeciesInfo.getFunctionalGroups();
                for (String functionalGroupKey : functionalGroups.keySet()) {
                    ArrayList<FunctionalGroup> fg = functionalGroups.get(functionalGroupKey);
                    String fgCounts = fg.stream().map(sfg -> "" + sfg.getCount()).collect(Collectors.joining("|"));
                    m.put("Total #" + functionalGroupKey, fgCounts);
                }
                for (FattyAcid fa : t.fattyAcids()) {
                    String faName = fa.getName();
                    m.put(faName + " SN Position", "" + fa.getPosition());
                    m.put(faName + " #C", "" + fa.getNumCarbon());
                    m.put(faName + " #DB", "" + fa.getDoubleBonds().getNumDoubleBonds());
                    m.put(faName + " Bond Type", fa.getLipidFaBondType().name());
                    String dbPositions = fa.getDoubleBonds().getDoubleBondPositions().entrySet().stream().map(entry -> String.valueOf(entry.getKey()) + (String)entry.getValue()).collect(Collectors.joining("|"));
                    m.put(faName + " DB Positions", dbPositions);
                    for (String functionalGroupKey : fa.getFunctionalGroups().keySet()) {
                        ArrayList<FunctionalGroup> fg = fa.getFunctionalGroups().get(functionalGroupKey);
                        String fgCounts = fg.stream().map(sfg -> "" + sfg.getCount()).collect(Collectors.joining("|"));
                        m.put("Total #" + functionalGroupKey, fgCounts);
                    }
                }
                m.put("Lipid Shorthand " + LipidLevel.CATEGORY.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.CATEGORY));
                m.put("Lipid Shorthand " + LipidLevel.CLASS.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.CLASS));
                m.put("Lipid Shorthand " + LipidLevel.SPECIES.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.SPECIES));
                m.put("Lipid Shorthand " + LipidLevel.MOLECULAR_SPECIES.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.MOLECULAR_SPECIES));
                m.put("Lipid Shorthand " + LipidLevel.SN_POSITION.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.SN_POSITION));
                m.put("Lipid Shorthand " + LipidLevel.STRUCTURE_DEFINED.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.STRUCTURE_DEFINED));
                m.put("Lipid Shorthand " + LipidLevel.FULL_STRUCTURE.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.FULL_STRUCTURE));
                m.put("Lipid Shorthand " + LipidLevel.COMPLETE_STRUCTURE.name(), CmdLineParser.nameForLevel(t.lipidAdduct, LipidLevel.COMPLETE_STRUCTURE));
            }
            keys.addAll(m.keySet());
            return m;
        }).toList();
        sb.append(keys.stream().collect(Collectors.joining("\t"))).append("\n");
        for (Map m : entries) {
            LinkedList<String> l = new LinkedList<String>();
            for (String key : keys) {
                l.add(m.getOrDefault(key, ""));
            }
            sb.append(l.stream().collect(Collectors.joining("\t"))).append("\n");
        }
        return sb.toString();
    }

    private static String nameForLevel(LipidAdduct la, LipidLevel level) {
        if (level.level <= la.getLipidLevel().level) {
            return la.getLipidString(level);
        }
        return "";
    }

    private static void writeToWriter(BufferedWriter bw, List<Pair<String, List<ValidationResult>>> results) {
        try {
            bw.write(CmdLineParser.toTable(results));
            bw.newLine();
        }
        catch (IOException ex) {
            log.error("Caught exception while trying to write validation results to buffered writer.", ex);
        }
    }

    private static List<Pair<String, List<ValidationResult>>> parseNames(Stream<String> lipidNames, boolean stripWhitespace) {
        LipidParser lipidParser = new LipidParser();
        return lipidNames.map(t -> CmdLineParser.parseName(stripWhitespace ? t.strip() : t, lipidParser)).toList().stream().map(t -> Pair.of((String)t.getKey(), Arrays.asList((ValidationResult)t.getValue()))).toList();
    }

    private static List<Pair<String, List<ValidationResult>>> parseNamesWith(Stream<String> lipidNames, Grammar grammar, boolean stripWhitespace) {
        return lipidNames.map(t -> CmdLineParser.parseNameWith(stripWhitespace ? t.strip() : t, grammar)).toList().stream().map(t -> Pair.of((String)t.getKey(), Arrays.asList((ValidationResult)t.getValue()))).toList();
    }

    private static Pair<String, ValidationResult> parseNameWith(String lipidName, Grammar grammar) {
        Parser<LipidAdduct> parser = CmdLineParser.loadParsers().get((Object)grammar);
        if (parser == null) {
            throw new ConstraintViolationException("Unsupported grammar: " + String.valueOf((Object)grammar));
        }
        try {
            String canonicalName;
            BaseParserEventHandler<LipidAdduct> handler = parser.newEventHandler();
            LipidAdduct la = parser.parse(lipidName, handler, false);
            if (la == null) {
                ValidationResult validationResult = new ValidationResult(lipidName, grammar, LipidLevel.NO_LEVEL, Arrays.asList(handler.getErrorMessage()), null, null, null, null, null, Collections.emptyList());
                log.debug("Could not parse " + lipidName + " with " + String.valueOf((Object)grammar) + " grammar: " + String.valueOf((Object)grammar) + ". Message: " + handler.getErrorMessage());
                return Pair.of(lipidName, validationResult);
            }
            try {
                canonicalName = la.getLipidString();
            }
            catch (RuntimeException re) {
                canonicalName = null;
                log.debug("Parsing error for {}!", (Object)lipidName);
            }
            ArrayList<FattyAcid> fas = CmdLineParser.extractFas(la);
            ValidationResult validationResult = new ValidationResult(lipidName, grammar, la.getLipidLevel(), Arrays.asList(handler.getErrorMessage()), la, la.getLipid().getInfo(), canonicalName, ((LipidClassMeta)CmdLineParser.LIPID_CLASSES.get((int)la.getLipid().getInfo().lipidClass)).lipidCategory.name(), CmdLineParser.getLipidMapsClassAbbreviation(((LipidClassMeta)CmdLineParser.LIPID_CLASSES.get((int)la.getLipid().getInfo().lipidClass)).lipidClassName), fas);
            return Pair.of(lipidName, validationResult);
        }
        catch (LipidException ex) {
            ValidationResult validationResult = new ValidationResult(lipidName, grammar, LipidLevel.NO_LEVEL, Arrays.asList("Parsing failed for lipid '" + lipidName + "' using grammar '" + String.valueOf((Object)grammar) + "' with exception: " + ex.getLocalizedMessage()), null, null, null, null, null, Collections.emptyList());
            log.error("Parsing failed for lipid '" + lipidName + "' using grammar '" + String.valueOf((Object)grammar) + "' with exception: " + ex.getLocalizedMessage(), ex);
            return Pair.of(lipidName, validationResult);
        }
    }

    private static Pair<String, ValidationResult> parseName(String lipidName, LipidParser parser) {
        Pair<String, ValidationResult> shorthandResult = null;
        try {
            String canonicalName;
            LipidAdduct la = parser.parse(lipidName);
            try {
                canonicalName = la.getLipidString();
            }
            catch (RuntimeException re) {
                canonicalName = null;
                log.debug("Parsing error for {}!", (Object)lipidName);
            }
            ArrayList<FattyAcid> fas = CmdLineParser.extractFas(la);
            ValidationResult validationResult = new ValidationResult(lipidName, Grammar.valueOf(parser.getLastSuccessfulGrammar().toUpperCase()), la.getLipidLevel(), Arrays.asList(""), la, la.getLipid().getInfo(), canonicalName, ((LipidClassMeta)CmdLineParser.LIPID_CLASSES.get((int)la.getLipid().getInfo().lipidClass)).lipidCategory.name(), CmdLineParser.getLipidMapsClassAbbreviation(((LipidClassMeta)CmdLineParser.LIPID_CLASSES.get((int)la.getLipid().getInfo().lipidClass)).lipidClassName), fas);
            shorthandResult = Pair.of(lipidName, validationResult);
        }
        catch (LipidException ex) {
            ValidationResult validationResult = new ValidationResult(lipidName, Grammar.NONE, LipidLevel.NO_LEVEL, Arrays.asList(ex.getMessage()), null, null, null, null, null, Collections.emptyList());
            log.debug("Could not parse " + lipidName + " with any grammar. Message: " + ex.getMessage());
            shorthandResult = Pair.of(lipidName, validationResult);
        }
        return shorthandResult;
    }

    private static ArrayList<FattyAcid> extractFas(LipidAdduct la) {
        return la.getLipid().getFaList();
    }

    private static String getLipidMapsClassAbbreviation(String lipidMapsClass) {
        Pattern lmcRegexp = Pattern.compile(LIPIDMAPS_CLASS_REGEXP);
        Matcher lmcMatcher = lmcRegexp.matcher(lipidMapsClass);
        if (lmcMatcher.matches() && lmcMatcher.groupCount() == 1) {
            return "[" + lmcMatcher.group(1) + "]";
        }
        return "";
    }

    protected static String addLipidFileInputOption(Options options) {
        String versionOpt = "file";
        options.addOption("f", versionOpt, true, "Input a file name to read from for lipid name for parsing. Each lipid name must be on a separate line.");
        return versionOpt;
    }

    protected static String addLipidNameInputOption(Options options) {
        String versionOpt = "name";
        options.addOption("n", versionOpt, true, "Input a lipid name for parsing.");
        return versionOpt;
    }

    protected static String addVersionOption(Options options) {
        String versionOpt = "version";
        options.addOption("v", versionOpt, false, "Print version information.");
        return versionOpt;
    }

    protected static String addHelpOption(Options options) {
        String helpOpt = "help";
        options.addOption("h", helpOpt, false, "Print help message.");
        return helpOpt;
    }

    protected static String addOutputToFileOption(Options options) {
        String outputToFileOpt = "outputFile";
        options.addOption("o", outputToFileOpt, false, "Write output to file 'goslin-out.tsv' instead of to std out.");
        return outputToFileOpt;
    }

    protected static String addStripWhitespaceOption(Options options) {
        String stripWhitespaceOpt = "stripWhitespace";
        options.addOption("w", stripWhitespaceOpt, false, "Strip leading and trailing whitespace of names passed to goslin. Be aware that original names in output will contain the stripped names!");
        return stripWhitespaceOpt;
    }

    protected static String addGrammarOption(Options options) {
        String grammarOpt = "grammar";
        options.addOption("g", grammarOpt, true, "Use the provided grammar explicitly instead of all grammars. Options are: " + Arrays.toString((Object[])Grammar.values()));
        return grammarOpt;
    }

    private static Map<Grammar, Parser<LipidAdduct>> loadParsers() {
        if (parsers.isEmpty()) {
            KnownFunctionalGroups kfg = new KnownFunctionalGroups();
            block9: for (Grammar grammar : Grammar.values()) {
                switch (grammar) {
                    case FATTYACIDS: {
                        parsers.put(grammar, new FattyAcidParser(kfg));
                        continue block9;
                    }
                    case GOSLIN: {
                        parsers.put(grammar, new GoslinParser(kfg));
                        continue block9;
                    }
                    case HMDB: {
                        parsers.put(grammar, new HmdbParser(kfg));
                        continue block9;
                    }
                    case LIPIDMAPS: {
                        parsers.put(grammar, new LipidMapsParser(kfg));
                        continue block9;
                    }
                    case SHORTHAND2020: {
                        parsers.put(grammar, new ShorthandParser(kfg));
                        continue block9;
                    }
                    case SWISSLIPIDS: {
                        parsers.put(grammar, new SwissLipidsParser(kfg));
                        continue block9;
                    }
                    case GOSLINFRAGMENTS: {
                        continue block9;
                    }
                }
            }
        }
        return parsers;
    }

    private static enum Grammar {
        GOSLIN,
        GOSLINFRAGMENTS,
        LIPIDMAPS,
        SWISSLIPIDS,
        HMDB,
        SHORTHAND2020,
        FATTYACIDS,
        NONE;

    }

    record ValidationResult(String lipidName, Grammar grammar, LipidLevel level, List<String> messages, LipidAdduct lipidAdduct, LipidSpeciesInfo lipidSpeciesInfo, String canonicalName, String lipidMapsCategory, String lipidMapsClass, List<FattyAcid> fattyAcids) {
        public ValidationResult {
            Objects.requireNonNull(messages);
            Objects.requireNonNull(fattyAcids);
        }
    }
}

