/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.ArrayList;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;

public final class AcylAlkylGroup
extends FunctionalGroup {
    private boolean alkyl;
    private boolean nitrogenBond;

    public AcylAlkylGroup(FattyAcid _fa, KnownFunctionalGroups knownFunctionalGroups) {
        this(_fa, -1, 1, false, false, knownFunctionalGroups);
    }

    public AcylAlkylGroup(FattyAcid _fa, int _position, int _count, boolean _alkyl, KnownFunctionalGroups knownFunctionalGroups) {
        this(_fa, _position, _count, _alkyl, false, knownFunctionalGroups);
    }

    public AcylAlkylGroup(FattyAcid _fa, int _position, int _count, boolean _alkyl, boolean _N_bond, KnownFunctionalGroups knownFunctionalGroups) {
        super("O", _position, _count, knownFunctionalGroups);
        this.alkyl = _alkyl;
        if (_fa != null) {
            String key = this.alkyl ? "alkyl" : "acyl";
            this.functionalGroups.put(key, new ArrayList());
            ((ArrayList)this.functionalGroups.get(key)).add(_fa);
        }
        this.doubleBonds.setNumDoubleBonds(this.alkyl ? 0 : 1);
        this.setNitrogenBond(_N_bond);
    }

    @Override
    public FunctionalGroup copy() {
        String key = this.alkyl ? "alkyl" : "acyl";
        return new AcylAlkylGroup((FattyAcid)((FunctionalGroup)((ArrayList)this.functionalGroups.get(key)).get(0)).copy(), this.getPosition(), this.getCount(), this.alkyl, this.nitrogenBond, this.knownFunctionalGroups);
    }

    public void setAlkyl(boolean alkyl) {
        this.alkyl = alkyl;
    }

    public boolean isAlkyl() {
        return this.alkyl;
    }

    public void setNitrogenBond(boolean _N_bond) {
        this.nitrogenBond = _N_bond;
        if (this.nitrogenBond) {
            this.elements.put(Element.H, this.alkyl ? 2 : 0);
            this.elements.put(Element.O, this.alkyl ? -1 : 0);
            this.elements.put(Element.N, 1);
        } else {
            this.elements.put(Element.H, this.alkyl ? 1 : -1);
            this.elements.put(Element.O, this.alkyl ? 0 : 1);
        }
    }

    public boolean isNitrogenBond() {
        return this.nitrogenBond;
    }

    @Override
    public String toString(LipidLevel level) {
        StringBuilder acyl_alkyl_string = new StringBuilder();
        if (level == LipidLevel.FULL_STRUCTURE) {
            acyl_alkyl_string.append(this.getPosition());
        }
        acyl_alkyl_string.append(this.nitrogenBond ? "N" : "O").append("(");
        if (!this.alkyl) {
            acyl_alkyl_string.append("FA ");
        }
        String key = this.alkyl ? "alkyl" : "acyl";
        acyl_alkyl_string.append(((FattyAcid)((ArrayList)this.functionalGroups.get(key)).get(0)).toString(level)).append(")");
        return acyl_alkyl_string.toString();
    }
}

