/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidSpecies;

public final class LipidAdduct {
    private final LipidSpecies lipid;
    private final Adduct adduct;

    public LipidAdduct(LipidSpecies lipid, Adduct adduct) {
        this.lipid = lipid;
        this.adduct = adduct;
    }

    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    public String getLipidString(LipidLevel level) {
        StringBuilder sb = new StringBuilder();
        if (this.lipid == null) {
            return "";
        }
        sb.append(this.lipid.getLipidString(level));
        switch (level) {
            case CLASS: 
            case CATEGORY: {
                break;
            }
            default: {
                if (this.adduct == null) break;
                sb.append(this.adduct.getLipidString());
            }
        }
        return sb.toString();
    }

    public String getClassName() {
        return this.lipid != null ? this.lipid.headGroup.getClassName() : "";
    }

    @JsonIgnore
    public boolean isLyso() {
        return LipidClasses.getInstance().size() > this.lipid.headGroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipid.headGroup.getLipidClass())).specialCases.contains("Lyso") : false;
    }

    @JsonIgnore
    public boolean isCardioLipin() {
        return LipidClasses.getInstance().size() > this.lipid.headGroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipid.headGroup.getLipidClass())).specialCases.contains("Cardio") : false;
    }

    @JsonIgnore
    public boolean isContainsSugar() {
        return LipidClasses.getInstance().size() > this.lipid.headGroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipid.headGroup.getLipidClass())).specialCases.contains("Sugar") : false;
    }

    @JsonIgnore
    public boolean isContainsEster() {
        return LipidClasses.getInstance().size() > this.lipid.headGroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipid.headGroup.getLipidClass())).specialCases.contains("Ester") : false;
    }

    @JsonIgnore
    public boolean isSpException() {
        return LipidClasses.getInstance().size() > this.lipid.headGroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipid.headGroup.getLipidClass())).specialCases.contains("SP_Exception") : false;
    }

    public LipidLevel getLipidLevel() {
        return this.lipid.getLipidLevel();
    }

    public String getExtendedClass() {
        return this.lipid != null ? this.lipid.getExtendedClass() : "";
    }

    public double getMass() {
        ElementTable elements = this.getElements();
        int charge = 0;
        double mass = 0.0;
        if (this.adduct != null) {
            charge = this.adduct.getCharge();
        }
        for (Map.Entry kvp : elements.entrySet()) {
            mass += Elements.ELEMENT_MASSES.get(kvp.getKey()) * (double)((Integer)kvp.getValue()).intValue();
        }
        if (charge != 0) {
            mass = (mass - (double)charge * 5.4857990946E-4) / (double)Math.abs(charge);
        }
        return mass;
    }

    @JsonIgnore
    public ElementTable getElements() {
        ElementTable elements = new ElementTable();
        if (this.lipid != null) {
            ElementTable lipid_elements = this.lipid.getElements();
            for (Map.Entry kv : lipid_elements.entrySet()) {
                elements.put((Element)((Object)kv.getKey()), (Integer)elements.get(kv.getKey()) + (Integer)kv.getValue());
            }
        }
        if (this.adduct != null) {
            ElementTable adduct_elements = this.adduct.getElements();
            for (Map.Entry kv : adduct_elements.entrySet()) {
                elements.put((Element)((Object)kv.getKey()), (Integer)elements.get(kv.getKey()) + (Integer)kv.getValue());
            }
        }
        return elements;
    }

    public String toString() {
        return this.getLipidString();
    }

    public String getSumFormula() {
        return this.getElements().getSumFormula();
    }

    public LipidSpecies getLipid() {
        return this.lipid;
    }

    public Adduct getAdduct() {
        return this.adduct;
    }
}

