/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Cycle;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidCompleteStructure;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidFullStructure;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidMolecularSpecies;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.domain.LipidSnPosition;
import org.lifstools.jgoslin.domain.LipidSpecies;
import org.lifstools.jgoslin.domain.LipidStructureDefined;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;

public abstract class LipidBaseParserEventHandler
extends BaseParserEventHandler<LipidAdduct> {
    protected LipidLevel level = LipidLevel.COMPLETE_STRUCTURE;
    protected String headGroup = "";
    protected FattyAcid lcb = null;
    protected List<FattyAcid> faList = new LinkedList<FattyAcid>();
    protected FattyAcid currentFa = null;
    protected Adduct adduct = null;
    protected ArrayList<HeadgroupDecorator> headgroupDecorators = new ArrayList();
    protected boolean useHeadGroup = false;
    protected KnownFunctionalGroups knownFunctionalGroups;
    protected static HashSet<String> SP_EXCEPTION_CLASSES = new HashSet<String>(Arrays.asList("Cer", "Ceramide", "Sphingosine", "So", "Sphinganine", "Sa", "SPH", "Sph", "LCB"));

    public LipidBaseParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        this.knownFunctionalGroups = knownFunctionalGroups;
    }

    protected void setLipidLevel(LipidLevel _level) {
        this.level = this.level.level < _level.level ? this.level : _level;
    }

    protected boolean spRegularLcb() {
        return !(Headgroup.getCategory(this.headGroup) != LipidCategory.SP || this.currentFa.getLipidFaBondType() != LipidFaBondType.LCB_REGULAR && this.currentFa.getLipidFaBondType() != LipidFaBondType.LCB_EXCEPTION || SP_EXCEPTION_CLASSES.contains(this.headGroup) && this.headgroupDecorators.isEmpty());
    }

    protected boolean check_full_structure(FunctionalGroup obj) {
        boolean full = true;
        boolean is_fa = obj instanceof FattyAcid;
        if (is_fa && ((FattyAcid)obj).getNumCarbon() == 0) {
            return true;
        }
        if (is_fa && obj.getDoubleBonds().getNumDoubleBonds() > 0 && obj.getDoubleBonds().getDoubleBondPositions().isEmpty()) {
            return false;
        }
        if (is_fa && !obj.getDoubleBonds().getDoubleBondPositions().isEmpty()) {
            int sum = 0;
            for (Map.Entry<Integer, String> kv : obj.getDoubleBonds().getDoubleBondPositions().entrySet()) {
                sum += kv.getValue().equals("E") || kv.getValue().equals("Z") || kv.getValue().equals("") && kv.getKey() == ((FattyAcid)obj).getNumCarbon() - 1 ? 1 : 0;
            }
            full &= sum == obj.getDoubleBonds().getDoubleBondPositions().size();
        }
        for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : obj.getFunctionalGroupsInternal().entrySet()) {
            for (FunctionalGroup fg : kv.getValue()) {
                if (fg.getName().equals("X")) continue;
                if (fg.getPosition() < 0) {
                    return false;
                }
                full &= this.check_full_structure(fg);
            }
        }
        return full;
    }

    protected Headgroup prepareHeadgroupAndChecks() {
        return this.prepareHeadgroupAndChecks(true);
    }

    protected Headgroup prepareHeadgroupAndChecks(boolean allowClassShift) {
        int max_num_fa;
        int poss_fa;
        Headgroup headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
        if (this.useHeadGroup) {
            return headgroup;
        }
        this.headGroup = headgroup.getClassName();
        int true_fa = 0;
        for (FattyAcid fa : this.faList) {
            true_fa += fa.getNumCarbon() > 0 || fa.getDoubleBonds().getNumDoubleBonds() > 0 ? 1 : 0;
        }
        int n = poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
        if (allowClassShift) {
            boolean can_be_lyso = LipidClasses.getInstance().size() > Headgroup.getClass("L" + this.headGroup) ? ((LipidClassMeta)LipidClasses.getInstance().get((int)Headgroup.getClass((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"L\u0001"}, (String)this.headGroup))))).specialCases.contains("Lyso") : false;
            LipidClassMeta l = (LipidClassMeta)LipidClasses.getInstance().get(Headgroup.getClass("LCL"));
            if ((true_fa + 1 == poss_fa || true_fa + 2 == poss_fa) && this.level != LipidLevel.SPECIES && headgroup.getLipidCategory() == LipidCategory.GP && can_be_lyso) {
                this.headGroup = true_fa + 1 == poss_fa ? "L" + this.headGroup : "DL" + this.headGroup;
                headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
                poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
            } else if ((true_fa + 1 == poss_fa || true_fa + 2 == poss_fa) && this.level != LipidLevel.SPECIES && headgroup.getLipidCategory() == LipidCategory.GL && this.headGroup.equals("TG")) {
                this.headGroup = true_fa + 1 == poss_fa ? "DG" : "MG";
                headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
                int n2 = poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
            }
        }
        if (LipidLevel.isLevel(this.level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
            for (FattyAcid fa : this.faList) {
                if (this.check_full_structure(fa)) continue;
                this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
                break;
            }
        }
        if (this.level == LipidLevel.SPECIES) {
            if (true_fa == 0 && poss_fa != 0) {
                throw new ConstraintViolationException("No fatty acyl information lipid class '" + headgroup.getHeadgroup() + "' provided.");
            }
        } else {
            if (true_fa != poss_fa && LipidLevel.isLevel(this.level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level)) {
                throw new ConstraintViolationException("Number of described fatty acyl chains (" + Integer.toString(true_fa) + ") not allowed for lipid class '" + headgroup.getHeadgroup() + "' (having " + Integer.toString(poss_fa) + " fatty aycl chains).");
            }
            if (((LipidClassMeta)LipidClasses.getInstance().get((int)Headgroup.getClass((String)this.headGroup))).specialCases.contains("Lyso") && true_fa > poss_fa) {
                throw new ConstraintViolationException("Number of described fatty acyl chains (" + Integer.toString(true_fa) + ") not allowed for lipid class '" + headgroup.getHeadgroup() + "' (having " + Integer.toString(poss_fa) + " fatty aycl chains).");
            }
        }
        if (((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).specialCases.contains("HC")) {
            this.faList.get(0).setLipidFaBondType(LipidFaBondType.ETHER);
        }
        if (((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).specialCases.contains("Amide")) {
            for (FattyAcid fatty : this.faList) {
                fatty.setLipidFaBondType(LipidFaBondType.AMIDE);
            }
        }
        int n3 = max_num_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).maxNumFa : 0;
        if (max_num_fa != this.faList.size()) {
            this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
        }
        if (this.faList.size() > 0 && headgroup.isSpException()) {
            this.faList.get(0).setType(LipidFaBondType.LCB_EXCEPTION);
        }
        return headgroup;
    }

    protected LipidSpecies assembleLipid(Headgroup headgroup) {
        for (FattyAcid fa : this.faList) {
            if (!fa.stereoInformationMissing()) continue;
            this.setLipidLevel(LipidLevel.FULL_STRUCTURE);
            break;
        }
        LipidSpecies ls = null;
        switch (this.level) {
            case COMPLETE_STRUCTURE: {
                ls = new LipidCompleteStructure(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case FULL_STRUCTURE: {
                ls = new LipidFullStructure(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case STRUCTURE_DEFINED: {
                ls = new LipidStructureDefined(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case SN_POSITION: {
                ls = new LipidSnPosition(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case MOLECULAR_SPECIES: {
                ls = new LipidMolecularSpecies(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case SPECIES: {
                ls = new LipidSpecies(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
        }
        return ls;
    }

    protected FattyAcid resolveFaSynonym(String mediatorName) {
        switch (mediatorName) {
            case "Palmitic acid": {
                return new FattyAcid("FA", 16, this.knownFunctionalGroups);
            }
            case "LA": 
            case "Linoleic acid": {
                return new FattyAcid("FA", 18, new DoubleBonds(2), this.knownFunctionalGroups);
            }
            case "Arachidonic acid": 
            case "AA": {
                return new FattyAcid("FA", 20, new DoubleBonds(4), this.knownFunctionalGroups);
            }
            case "ALA": {
                return new FattyAcid("FA", 18, new DoubleBonds(3), this.knownFunctionalGroups);
            }
            case "EPA": {
                return new FattyAcid("FA", 20, new DoubleBonds(5), this.knownFunctionalGroups);
            }
            case "DHA": {
                return new FattyAcid("FA", 22, new DoubleBonds(6), this.knownFunctionalGroups);
            }
            case "LTB4": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(5);
                f2.setPosition(12);
                DoubleBonds db = new DoubleBonds(new TreeMap<Integer, String>(Map.of(6, "Z", 8, "E", 10, "E", 14, "Z")));
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                return new FattyAcid("FA", 20, db, fg, this.knownFunctionalGroups);
            }
            case "RvD3": 
            case "Resolvin D3": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(11);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                return new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
            }
            case "Mar1": 
            case "Maresin 1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(14);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                return new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
            }
            case "Resolvin D2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(4);
                f2.setPosition(16);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                return new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
            }
            case "Resolvin D5": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(7);
                f2.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2))));
                return new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
            }
            case "Resolvin D1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(7);
                f2.setPosition(8);
                f3.setPosition(17);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2, f3))));
                return new FattyAcid("FA", 22, new DoubleBonds(6), fg, this.knownFunctionalGroups);
            }
            case "TXB1": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(1), fg, this.knownFunctionalGroups);
            }
            case "TXB2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxy", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "TXB3": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f4 = this.knownFunctionalGroups.get("oxy");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                f4.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)), "oxy", new ArrayList<FunctionalGroup>(Arrays.asList(f4))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(3), fg, this.knownFunctionalGroups);
            }
            case "PGF2alpha": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "PGD2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("oxo");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f3))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "PGE2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("oxo");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f3)), "oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "PGB2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, new DoubleBonds(1), fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "15d-PGJ2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("oxo");
                f1.setPosition(15);
                f2.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("oxo", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, new DoubleBonds(1), fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(3), fg, this.knownFunctionalGroups);
            }
            case "PGJ2": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("oxo");
                f1.setPosition(15);
                f2.setPosition(11);
                HashMap<String, ArrayList<FunctionalGroup>> fgc = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2))));
                Cycle cy = new Cycle(5, 8, 12, new DoubleBonds(1), fgc, this.knownFunctionalGroups);
                HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy))));
                return new FattyAcid("FA", 20, new DoubleBonds(2), fg, this.knownFunctionalGroups);
            }
            case "PGF1alpha": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(15);
                f2.setPosition(9);
                f3.setPosition(11);
                Cycle cy = new Cycle(5, 8, 12, null, new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)))), this.knownFunctionalGroups);
                return new FattyAcid("FA", 20, new DoubleBonds(1), new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy)))), this.knownFunctionalGroups);
            }
            case "PDX": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(10);
                f2.setPosition(17);
                return new FattyAcid("FA", 2, new DoubleBonds(6), new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1, f2)))), this.knownFunctionalGroups);
            }
            case "Oleic acid": 
            case "OA": {
                return new FattyAcid("FA", 18, new DoubleBonds(1));
            }
            case "DGLA": {
                return new FattyAcid("FA", 20, new DoubleBonds(3));
            }
            case "iPF2alpha-VI": {
                FunctionalGroup f1 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f2 = this.knownFunctionalGroups.get("OH");
                FunctionalGroup f3 = this.knownFunctionalGroups.get("OH");
                f1.setPosition(5);
                f2.setPosition(9);
                f3.setPosition(11);
                Cycle cy = new Cycle(5, 8, 12, null, new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f2, f3)))), this.knownFunctionalGroups);
                return new FattyAcid("FA", 20, new DoubleBonds(2), new HashMap<String, ArrayList<FunctionalGroup>>(Map.of("OH", new ArrayList<FunctionalGroup>(Arrays.asList(f1)), "cy", new ArrayList<FunctionalGroup>(Arrays.asList(cy)))), this.knownFunctionalGroups);
            }
        }
        throw new LipidParsingException("Mediator '" + mediatorName + "' is unknown.");
    }
}

