/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class StringFunctions {
    public static char DEFAULT_QUOTE = (char)39;
    public static char DEFAULT_SPLIT = (char)44;

    private StringFunctions() {
    }

    public static String strip(String s, char c) {
        if (s.length() > 0) {
            int st;
            for (st = 0; st < s.length() - 1 && s.charAt(st) == c; ++st) {
            }
            s = s.substring(st, s.length());
        }
        if (s.length() > 0) {
            int en;
            for (en = 0; en < s.length() - 1 && s.charAt(s.length() - 1 - en) == c; ++en) {
            }
            s = s.substring(0, s.length() - en);
        }
        return s;
    }

    public static ArrayList<String> splitString(String text) {
        return StringFunctions.splitString(text, DEFAULT_SPLIT, DEFAULT_QUOTE, false);
    }

    public static ArrayList<String> splitString(String text, char separator, char quote) {
        return StringFunctions.splitString(text, separator, quote, false);
    }

    public static ArrayList<String> splitString(String text, char separator, char quote, boolean withEmpty) {
        boolean in_quote = false;
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int last_char = 0;
        boolean last_escaped_backslash = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean escaped_backslash = false;
            if (!in_quote) {
                if (c == separator) {
                    String sb_string = sb.toString();
                    if (sb_string.length() > 0 || withEmpty) {
                        tokens.add(sb_string);
                    }
                    sb = new StringBuilder();
                } else {
                    if (c == quote) {
                        in_quote = !in_quote;
                    }
                    sb.append(c);
                }
            } else {
                if (c == '\\' && last_char == 92 && !last_escaped_backslash) {
                    escaped_backslash = true;
                } else if (c == quote && (last_char != 92 || last_escaped_backslash)) {
                    in_quote = !in_quote;
                }
                sb.append(c);
            }
            last_escaped_backslash = escaped_backslash;
            last_char = c;
        }
        String sb_string_end = sb.toString();
        if (sb_string_end.length() > 0 || last_char == 44 && withEmpty) {
            tokens.add(sb_string_end);
        }
        if (in_quote) {
            throw new ConstraintViolationException("Error: corrupt token in grammar: '" + sb_string_end + "'");
        }
        return tokens;
    }

    public static List<String> getResourceAsStringList(Resource resource) {
        ArrayList lines;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream()));){
            lines = br.lines().collect(Collectors.toCollection(ArrayList::new));
        }
        catch (IOException e) {
            throw new ConstraintViolationException("Error: Resource '" + resource.getDescription() + "' does not exist.", e);
        }
        return lines;
    }

    public static List<String> getResourceAsStringList(String resourcePath) {
        return StringFunctions.getResourceAsStringList((Resource)new ClassPathResource(resourcePath));
    }

    public static String getResourceAsString(Resource resource) {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(resource.getInputStream()));
        try {
            br.lines().forEach(line -> sb.append((String)line).append("\n"));
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConstraintViolationException("Error: Resource '" + resource.getDescription() + "' does not exist.", e);
            }
        }
        br.close();
        return string;
    }

    public static String getResourceAsString(String resourcePath) {
        return StringFunctions.getResourceAsString((Resource)new ClassPathResource(resourcePath));
    }
}

