/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.Map;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class SumFormulaParserEventHandler
extends BaseParserEventHandler<ElementTable> {
    private Element element;
    private int count;

    public SumFormulaParserEventHandler() {
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("molecule_pre_event", this::resetParser), Map.entry("element_group_post_event", this::elementGroupPostEvent), Map.entry("element_pre_event", this::elementPreEvent), Map.entry("single_element_pre_event", this::singleElementGroupPreEvent), Map.entry("count_pre_event", this::countPreEvent));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize ShorthandParserEventHandler.");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = new ElementTable();
        this.element = Element.H;
        this.count = 0;
    }

    private void elementGroupPostEvent(TreeNode node) {
        ((ElementTable)this.content).put(this.element, (Integer)((ElementTable)this.content).get((Object)this.element) + this.count);
    }

    private void elementPreEvent(TreeNode node) {
        String parsed_element = node.getText();
        if (!Elements.ELEMENT_POSITIONS.containsKey(parsed_element)) {
            throw new LipidException("Error: element '" + parsed_element + "' is unknown");
        }
        this.element = Elements.ELEMENT_POSITIONS.get(parsed_element);
    }

    private void singleElementGroupPreEvent(TreeNode node) {
        String parsed_element = node.getText();
        if (!Elements.ELEMENT_POSITIONS.containsKey(parsed_element)) {
            throw new LipidException("Error: element '" + parsed_element + "' is unknown");
        }
        this.element = Elements.ELEMENT_POSITIONS.get(parsed_element);
        ((ElementTable)this.content).put(this.element, (Integer)((ElementTable)this.content).get((Object)this.element) + 1);
    }

    private void countPreEvent(TreeNode node) {
        this.count = Integer.valueOf(node.getText());
    }
}

