/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;

public final class Adduct {
    private String sumFormula;
    private String adductString;
    private int charge;
    private int chargeSign;
    private ElementTable heavyElements = new ElementTable();
    public static final Map<String, ElementTable> ADDUCTS = Map.ofEntries(Map.entry("+H", ElementTable.of(Map.entry(Element.H, 1))), Map.entry("+2H", ElementTable.of(Map.entry(Element.H, 2))), Map.entry("+3H", ElementTable.of(Map.entry(Element.H, 3))), Map.entry("+4H", ElementTable.of(Map.entry(Element.H, 4))), Map.entry("-H", ElementTable.of(Map.entry(Element.H, -1))), Map.entry("-2H", ElementTable.of(Map.entry(Element.H, -2))), Map.entry("-3H", ElementTable.of(Map.entry(Element.H, -3))), Map.entry("-4H", ElementTable.of(Map.entry(Element.H, -4))), Map.entry("+H-H2O", ElementTable.of(Map.entry(Element.H, -1), Map.entry(Element.O, -1))), Map.entry("+NH4", ElementTable.of(Map.entry(Element.N, 1), Map.entry(Element.H, 4))), Map.entry("+Cl", ElementTable.of(Map.entry(Element.Cl, 1))), Map.entry("+HCOO", ElementTable.of(Map.entry(Element.H, 1), Map.entry(Element.C, 1), Map.entry(Element.O, 2))), Map.entry("+CH3COO", ElementTable.of(Map.entry(Element.H, 3), Map.entry(Element.C, 2), Map.entry(Element.O, 2))));
    public static final Map<String, Integer> ADDUCT_CHARGES = Map.ofEntries(Map.entry("+H", 1), Map.entry("+2H", 2), Map.entry("+3H", 3), Map.entry("+4H", 4), Map.entry("-H", -1), Map.entry("-2H", -2), Map.entry("-3H", -3), Map.entry("-4H", -4), Map.entry("+H-H2O", 1), Map.entry("+NH4", 1), Map.entry("+Cl", -1), Map.entry("+HCOO", -1), Map.entry("+CH3COO", -1));

    public Adduct(String _sum_formula, String _adduct_string) {
        this(_sum_formula, _adduct_string, 0, 1);
    }

    public Adduct(String _sum_formula, String _adduct_string, int _charge, int _sign) {
        this.sumFormula = _sum_formula;
        this.adductString = _adduct_string;
        this.charge = _charge;
        this.setChargeSign(_sign);
    }

    public void setSumFormula(String sumFormula) {
        this.sumFormula = sumFormula;
    }

    public String getSumFormula() {
        return this.sumFormula;
    }

    public void setAdductString(String adductString) {
        this.adductString = adductString;
    }

    public String getAdductString() {
        return this.adductString;
    }

    public ElementTable getHeavyElements() {
        return this.heavyElements;
    }

    public void setChargeSign(int _sign) {
        if (-1 > _sign || _sign > 1) {
            throw new ConstraintViolationException("Sign can only be -1, 0, or 1");
        }
        this.chargeSign = _sign;
    }

    public int getChargeSign() {
        return this.chargeSign;
    }

    public void setCharge(int charge) {
        this.chargeSign = charge > 0 ? 1 : -1;
        this.charge = charge;
    }

    public String getHeavyIsotopeString() {
        StringBuilder sb = new StringBuilder();
        for (Element e : Elements.ELEMENT_ORDER) {
            if ((Integer)this.heavyElements.get((Object)e) <= 0) continue;
            if ((Integer)this.heavyElements.get((Object)e) == 1) {
                sb.append(Elements.HEAVY_SHORTCUT.get((Object)e));
                continue;
            }
            sb.append(Elements.HEAVY_SHORTCUT.get((Object)e)).append(this.heavyElements.get((Object)e));
        }
        return sb.toString();
    }

    public String getLipidString() {
        if (this.charge == 0) {
            return "[M" + this.getHeavyIsotopeString() + "]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[M").append(this.getHeavyIsotopeString()).append(this.sumFormula).append(this.adductString).append("]").append(this.charge).append(this.chargeSign > 0 ? "+" : "-");
        return sb.toString();
    }

    @JsonIgnore
    public ElementTable getElements() {
        ElementTable elements = new ElementTable();
        for (Map.Entry kv : this.heavyElements.entrySet()) {
            if ((Integer)kv.getValue() <= 0) continue;
            Element regular = Elements.HEAVY_TO_REGULAR.get(kv.getKey());
            elements.put(regular, (Integer)elements.get((Object)regular) - (Integer)kv.getValue());
            elements.put((Element)((Object)kv.getKey()), (Integer)elements.get(kv.getKey()) + (Integer)kv.getValue());
        }
        if (this.adductString.length() > 0) {
            if (ADDUCTS.containsKey(this.adductString)) {
                if (ADDUCT_CHARGES.get(this.adductString).intValue() != this.getCharge()) {
                    throw new ConstraintViolationException("Provided charge '" + this.getCharge() + "' in contradiction to adduct '" + this.adductString + "' charge '" + ADDUCT_CHARGES.get(this.adductString) + "'.");
                }
                elements.add(ADDUCTS.get(this.adductString));
            } else {
                throw new ConstraintViolationException("Adduct '" + this.adductString + "' is unknown.");
            }
        }
        return elements;
    }

    public int getCharge() {
        return this.charge * this.chargeSign;
    }
}

