/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.EnumMap;
import java.util.Map;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.Elements;

public final class ElementTable
extends EnumMap<Element, Integer> {
    private ElementTable(Class<Element> keyType) {
        super(keyType);
    }

    public ElementTable() {
        this(Element.class);
        Elements.ELEMENT_MASSES.keySet().forEach((? super T e) -> this.put(e, 0));
    }

    public static ElementTable of(Map.Entry<Element, Integer> ... entries) {
        ElementTable et = new ElementTable();
        for (Map.Entry<Element, Integer> e : entries) {
            et.put(e.getKey(), e.getValue());
        }
        return et;
    }

    public void add(ElementTable elements) {
        elements.entrySet().forEach((? super T kv) -> this.put((Element)((Object)((Object)kv.getKey())), (Integer)this.get(kv.getKey()) + (Integer)kv.getValue()));
    }

    public void add(ElementTable elements, int multiplier) {
        elements.entrySet().forEach((? super T kv) -> this.put((Element)((Object)((Object)kv.getKey())), (Integer)this.get(kv.getKey()) + (Integer)kv.getValue() * multiplier));
    }

    public ElementTable copy() {
        ElementTable e = new ElementTable();
        this.entrySet().forEach((? super T kv) -> e.put((Element)((Object)((Object)kv.getKey())), (Integer)kv.getValue()));
        return e;
    }

    public String getSumFormula() {
        StringBuilder ss = new StringBuilder();
        Elements.ELEMENT_ORDER.stream().map(e -> {
            if ((Integer)this.get(e) > 0) {
                ss.append(Elements.ELEMENT_SHORTCUT.get(e));
            }
            return e;
        }).filter(e -> (Integer)this.get(e) > 1).forEachOrdered(e -> ss.append(this.get(e)));
        return ss.toString();
    }

    public Double getMass(Element element) {
        Integer count = this.getOrDefault((Object)element, 0);
        return count.doubleValue() * Elements.ELEMENT_MASSES.get((Object)element);
    }

    public Double getMass() {
        return this.keySet().stream().map(key -> this.getMass((Element)((Object)key))).reduce(0.0, Double::sum);
    }

    public Double getChargedMass(int charge) {
        Double mass = this.getMass();
        if (charge != 0) {
            mass = (mass - (double)charge * 5.4857990946E-4) / (double)Math.abs(charge);
        }
        return mass;
    }
}

