/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;

public class FattyAcid
extends FunctionalGroup {
    public static final Set<String> fgExceptions = new HashSet<String>(Arrays.asList("acyl", "alkyl", "cy", "cc", "acetoxy"));
    public static final Set<LipidFaBondType> LCB_STATES = new HashSet<LipidFaBondType>(Arrays.asList(LipidFaBondType.LCB_REGULAR, LipidFaBondType.LCB_EXCEPTION));
    protected int numCarbon;
    protected LipidFaBondType lipidFaBondType;

    public FattyAcid(String _name, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, 0, null, null, LipidFaBondType.ESTER, 0, knownFunctionalGroups);
    }

    public FattyAcid(String _name, int _num_carbon, DoubleBonds _double_bonds) {
        this(_name, _num_carbon, _double_bonds, null, LipidFaBondType.ESTER, 0, null);
    }

    public FattyAcid(String _name, int _num_carbon, DoubleBonds _double_bonds, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _num_carbon, _double_bonds, null, LipidFaBondType.ESTER, 0, knownFunctionalGroups);
    }

    public FattyAcid(String _name, int _num_carbon, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _num_carbon, null, null, LipidFaBondType.ESTER, 0, knownFunctionalGroups);
    }

    public FattyAcid(String _name, int _num_carbon, DoubleBonds _double_bonds, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _num_carbon, _double_bonds, _functional_groups, LipidFaBondType.ESTER, 0, knownFunctionalGroups);
    }

    public FattyAcid(String _name, int _num_carbon, DoubleBonds _double_bonds, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, LipidFaBondType _lipid_FA_bond_type, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _num_carbon, _double_bonds, _functional_groups, _lipid_FA_bond_type, 0, knownFunctionalGroups);
    }

    public FattyAcid(String _name, int _num_carbon, DoubleBonds _double_bonds, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, LipidFaBondType _lipid_FA_bond_type, int _position, KnownFunctionalGroups knownFunctionalGroups) {
        super(_name, _position, 1, _double_bonds, false, "", false, null, _functional_groups, knownFunctionalGroups);
        this.numCarbon = _num_carbon;
        this.lipidFaBondType = _lipid_FA_bond_type;
        if (this.lipidFaBondType == LipidFaBondType.LCB_REGULAR) {
            this.functionalGroups.put("[X]", new ArrayList());
            ((ArrayList)this.functionalGroups.get("[X]")).add(knownFunctionalGroups.get("X"));
        }
        if (this.numCarbon < 0 || this.numCarbon == 1) {
            throw new ConstraintViolationException("FattyAcid must have at least 2 carbons! Got " + Integer.toString(this.numCarbon));
        }
        if (this.getPosition() < 0) {
            throw new ConstraintViolationException("FattyAcid position must be greater or equal to 0! Got " + Integer.toString(this.getPosition()));
        }
        if (this.doubleBonds.getNumDoubleBonds() < 0) {
            throw new ConstraintViolationException("FattyAcid must have at least 0 double bonds! Got " + Integer.toString(this.doubleBonds.getNumDoubleBonds()));
        }
    }

    @Override
    public FunctionalGroup copy() {
        DoubleBonds db = this.doubleBonds.copy();
        HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>();
        for (Map.Entry kv : this.functionalGroups.entrySet()) {
            fg.put((String)kv.getKey(), new ArrayList());
            for (FunctionalGroup func_group : (ArrayList)kv.getValue()) {
                fg.get(kv.getKey()).add(func_group.copy());
            }
        }
        return new FattyAcid(this.getName(), this.numCarbon, db, fg, this.lipidFaBondType, this.getPosition(), this.knownFunctionalGroups);
    }

    public void setType(LipidFaBondType _lipid_FA_bond_type) {
        this.lipidFaBondType = _lipid_FA_bond_type;
        if (this.lipidFaBondType == LipidFaBondType.LCB_REGULAR && !this.functionalGroups.containsKey("[X]")) {
            this.functionalGroups.put("[X]", new ArrayList());
            ((ArrayList)this.functionalGroups.get("[X]")).add(this.knownFunctionalGroups.get("X"));
        } else if (this.functionalGroups.containsKey("[X]")) {
            this.functionalGroups.remove("[X]");
        }
        this.setName(this.lipidFaBondType != LipidFaBondType.LCB_EXCEPTION && this.lipidFaBondType != LipidFaBondType.LCB_REGULAR ? "FA" : "LCB");
    }

    public String getPrefix(LipidFaBondType lipid_FA_bond_type) {
        switch (lipid_FA_bond_type) {
            case ETHER_PLASMANYL: {
                return "O-";
            }
            case ETHER_PLASMENYL: {
                return "P-";
            }
        }
        return "";
    }

    @Override
    public int getNDoubleBonds() {
        return super.getNDoubleBonds() + (this.lipidFaBondType == LipidFaBondType.ETHER_PLASMENYL ? 1 : 0);
    }

    public boolean lipidFaBondTypePrefix(LipidFaBondType lipid_FA_bond_type) {
        return lipid_FA_bond_type == LipidFaBondType.ETHER_PLASMANYL || lipid_FA_bond_type == LipidFaBondType.ETHER_PLASMENYL || lipid_FA_bond_type == LipidFaBondType.ETHER_UNSPECIFIED;
    }

    @Override
    public String toString(LipidLevel level) {
        StringBuilder fa_string = new StringBuilder();
        fa_string.append(this.getPrefix(this.lipidFaBondType));
        int num_carbons = this.numCarbon;
        int num_double_bonds = this.doubleBonds.getNumDoubleBonds();
        if (num_carbons == 0 && num_double_bonds == 0 && !LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level | LipidLevel.SN_POSITION.level)) {
            return "";
        }
        if (LipidLevel.isLevel(level, LipidLevel.SN_POSITION.level | LipidLevel.MOLECULAR_SPECIES.level)) {
            ElementTable e = this.computeAndCopyElements();
            num_carbons = (Integer)e.get((Object)Element.C);
            num_double_bonds = this.getNDoubleBonds() - (this.lipidFaBondType == LipidFaBondType.ETHER_PLASMENYL ? 1 : 0);
        }
        fa_string.append(num_carbons).append(":").append(num_double_bonds);
        if (!LipidLevel.isLevel(level, LipidLevel.SN_POSITION.level | LipidLevel.MOLECULAR_SPECIES.level) && this.doubleBonds.doubleBondPositions.size() > 0) {
            fa_string.append("(");
            int i = 0;
            Iterator sorted_db = new ArrayList<Integer>(this.doubleBonds.doubleBondPositions.keySet());
            Collections.sort(sorted_db, (a, b) -> a - b);
            Iterator iterator = ((ArrayList)((Object)sorted_db)).iterator();
            while (iterator.hasNext()) {
                int db_pos = (Integer)iterator.next();
                if (i++ > 0) {
                    fa_string.append(",");
                }
                fa_string.append(db_pos);
                if (!LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) continue;
                fa_string.append(this.doubleBonds.doubleBondPositions.get(db_pos));
            }
            fa_string.append(")");
        }
        if (level == LipidLevel.COMPLETE_STRUCTURE && this.stereochemistry.length() > 0) {
            fa_string.append("[").append(this.stereochemistry).append("]");
        }
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
            fg_names = new ArrayList<String>();
            for (Map.Entry entry : this.functionalGroups.entrySet()) {
                fg_names.add((String)entry.getKey());
            }
            Collections.sort(fg_names, (a, b) -> a.toLowerCase().compareTo(b.toLowerCase()));
            for (String string : fg_names) {
                ArrayList fg_list;
                if (string.equals("[X]") || (fg_list = (ArrayList)this.functionalGroups.get(string)).isEmpty()) continue;
                Collections.sort(fg_list, (a, b) -> a.getPosition() - b.getPosition());
                int i = 0;
                fa_string.append(";");
                for (FunctionalGroup func_group : fg_list) {
                    if (i++ > 0) {
                        fa_string.append(",");
                    }
                    fa_string.append(func_group.toString(level));
                }
            }
        } else if (level == LipidLevel.STRUCTURE_DEFINED) {
            fg_names = new ArrayList();
            this.functionalGroups.entrySet().forEach(kv -> fg_names.add((String)kv.getKey()));
            Collections.sort(fg_names, (a, b) -> a.toLowerCase().compareTo(b.toLowerCase()));
            for (String string : fg_names) {
                ArrayList fg_list;
                if (string.equals("[X]") || (fg_list = (ArrayList)this.functionalGroups.get(string)).isEmpty()) continue;
                if (fgExceptions.contains(string)) {
                    fa_string.append(";");
                    int i = 0;
                    for (FunctionalGroup func_group : fg_list) {
                        if (i++ > 0) {
                            fa_string.append(",");
                        }
                        fa_string.append(func_group.toString(level));
                    }
                    continue;
                }
                int fg_count = 0;
                for (FunctionalGroup func_group : fg_list) {
                    fg_count += func_group.getCount();
                }
                if (fg_count > 1) {
                    fa_string.append(";").append(!((FunctionalGroup)fg_list.get((int)0)).atomic ? "(" + string + ")" + Integer.toString(fg_count) : string + Integer.toString(fg_count));
                    continue;
                }
                fa_string.append(";").append(string);
            }
        } else {
            ElementTable func_elements = this.getFunctionalGroupElements();
            for (int i = 2; i < Elements.ELEMENT_ORDER.size(); ++i) {
                Element element = Elements.ELEMENT_ORDER.get(i);
                if ((Integer)func_elements.get((Object)element) <= 0) continue;
                fa_string.append(";").append(Elements.ELEMENT_SHORTCUT.get((Object)element));
                if ((Integer)func_elements.get((Object)element) <= 1) continue;
                fa_string.append(func_elements.get((Object)element));
            }
        }
        return fa_string.toString();
    }

    @Override
    @JsonIgnore
    public ElementTable getFunctionalGroupElements() {
        ElementTable fgElements = super.getFunctionalGroupElements();
        if (this.lipidFaBondType == LipidFaBondType.LCB_REGULAR && this.functionalGroups.containsKey("O")) {
            fgElements.put(Element.O, (Integer)fgElements.get((Object)Element.O) - 1);
        }
        return fgElements;
    }

    @Override
    public void computeElements() {
        block9: {
            int num_double_bonds;
            block8: {
                this.elements = new ElementTable();
                num_double_bonds = this.doubleBonds.getNumDoubleBonds();
                if (this.lipidFaBondType == LipidFaBondType.ETHER_PLASMENYL) {
                    ++num_double_bonds;
                }
                if (this.numCarbon == 0 && num_double_bonds == 0) {
                    this.elements.put(Element.H, 1);
                    return;
                }
                if (this.lipidFaBondType == LipidFaBondType.LCB_EXCEPTION || this.lipidFaBondType == LipidFaBondType.LCB_REGULAR) break block8;
                this.elements.put(Element.C, this.numCarbon);
                switch (this.lipidFaBondType) {
                    case ESTER: {
                        this.elements.put(Element.H, 2 * this.numCarbon - 1 - 2 * num_double_bonds);
                        this.elements.put(Element.O, 1);
                        break block9;
                    }
                    case ETHER_PLASMENYL: {
                        this.elements.put(Element.H, 2 * this.numCarbon - 1 - 2 * num_double_bonds + 2);
                        break block9;
                    }
                    case ETHER_PLASMANYL: 
                    case ETHER: {
                        this.elements.put(Element.H, (this.numCarbon + 1) * 2 - 1 - 2 * num_double_bonds);
                        break block9;
                    }
                    case AMIDE: {
                        this.elements.put(Element.H, 2 * this.numCarbon + 1 - 2 * num_double_bonds - 1);
                        break block9;
                    }
                    default: {
                        throw new LipidException("Mass cannot be computed for fatty acyl chain with this bond type");
                    }
                }
            }
            this.elements.put(Element.C, this.numCarbon);
            this.elements.put(Element.H, 2 * (this.numCarbon - num_double_bonds) + 1);
            this.elements.put(Element.N, 1);
        }
    }

    public int getNumCarbon() {
        return this.numCarbon;
    }

    public void setNumCarbon(int numCarbon) {
        this.numCarbon = numCarbon;
    }

    public LipidFaBondType getLipidFaBondType() {
        return this.lipidFaBondType;
    }

    public void setLipidFaBondType(LipidFaBondType lipidFaBondType) {
        this.lipidFaBondType = lipidFaBondType;
    }
}

