/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.ArrayList;
import java.util.Map;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;

public final class HeadgroupDecorator
extends FunctionalGroup
implements Comparable<HeadgroupDecorator> {
    private final boolean suffix;
    private final LipidLevel lowestVisibleLevel;

    @Override
    public int compareTo(HeadgroupDecorator hg) {
        if (this.name.compareTo(hg.name) < 0) {
            return -1;
        }
        return 1;
    }

    public HeadgroupDecorator(String _name, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, -1, 1, null, false, LipidLevel.NO_LEVEL, knownFunctionalGroups);
    }

    public HeadgroupDecorator(String _name, int _position, int _count, ElementTable _elements, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _position, _count, _elements, false, LipidLevel.NO_LEVEL, knownFunctionalGroups);
    }

    public HeadgroupDecorator(String _name, int _position, int _count, ElementTable _elements, boolean _suffix, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _position, _count, _elements, _suffix, LipidLevel.NO_LEVEL, knownFunctionalGroups);
    }

    public HeadgroupDecorator(String _name, int _position, int _count, ElementTable _elements, boolean _suffix, LipidLevel _level, KnownFunctionalGroups knownFunctionalGroups) {
        super(_name, _position, _count, null, false, "", false, _elements, knownFunctionalGroups);
        this.suffix = _suffix;
        this.lowestVisibleLevel = _level;
    }

    @Override
    public FunctionalGroup copy() {
        ElementTable e = new ElementTable();
        for (Map.Entry kv : this.computeAndCopyElements().entrySet()) {
            e.put((Element)((Object)kv.getKey()), (Integer)e.get(kv.getKey()) + (Integer)kv.getValue());
        }
        return new HeadgroupDecorator(this.getName(), this.getPosition(), this.getCount(), e, this.suffix, this.lowestVisibleLevel, this.knownFunctionalGroups);
    }

    @Override
    public String toString(LipidLevel level) {
        if (!this.suffix) {
            return this.getName() + (this.count > 1 ? Integer.toString(this.count) : "");
        }
        Object decorator_string = "";
        if (this.lowestVisibleLevel == LipidLevel.NO_LEVEL || this.lowestVisibleLevel.level <= level.level) {
            decorator_string = this.functionalGroups.containsKey("decorator_alkyl") ? (((ArrayList)this.functionalGroups.get("decorator_alkyl")).size() > 0 ? (level.level > LipidLevel.SPECIES.level ? ((FunctionalGroup)((ArrayList)this.functionalGroups.get("decorator_alkyl")).get(0)).toString(level) : "Alk") : "Alk") : (this.functionalGroups.containsKey("decorator_acyl") ? (((ArrayList)this.functionalGroups.get("decorator_acyl")).size() > 0 ? (level.level > LipidLevel.SPECIES.level ? "FA " + ((FunctionalGroup)((ArrayList)this.functionalGroups.get("decorator_acyl")).get(0)).toString(level) : "FA") : "FA") : this.getName());
            decorator_string = "(" + (String)decorator_string + ")";
        }
        return decorator_string;
    }

    public boolean isSuffix() {
        return this.suffix;
    }

    public LipidLevel getLowestVisibleLevel() {
        return this.lowestVisibleLevel;
    }
}

