/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidCompleteStructure;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidFullStructure;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidMolecularSpecies;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.domain.LipidSnPosition;
import org.lifstools.jgoslin.domain.LipidSpecies;
import org.lifstools.jgoslin.domain.LipidStructureDefined;
import org.lifstools.jgoslin.parser.BaseParserEventHandler;

public abstract class LipidBaseParserEventHandler
extends BaseParserEventHandler<LipidAdduct> {
    protected LipidLevel level = LipidLevel.COMPLETE_STRUCTURE;
    protected String headGroup = "";
    protected FattyAcid lcb = null;
    protected List<FattyAcid> faList = new LinkedList<FattyAcid>();
    protected FattyAcid currentFa = null;
    protected Adduct adduct = null;
    protected ArrayList<HeadgroupDecorator> headgroupDecorators = new ArrayList();
    protected boolean useHeadGroup = false;
    protected KnownFunctionalGroups knownFunctionalGroups;
    private static final Map<String, ArrayList<String>> GLYCO_TABLE = Map.ofEntries(Map.entry("ga2", new ArrayList<String>(Arrays.asList("GalNAc", "Gal", "Glc"))), Map.entry("gb3", new ArrayList<String>(Arrays.asList("Gal", "Gal", "Glc"))), Map.entry("gb4", new ArrayList<String>(Arrays.asList("GalNAc", "Gal", "Gal", "Glc"))), Map.entry("gd1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gd1a", new ArrayList<String>(Arrays.asList("Hex", "Hex", "Hex", "HexNAc", "NeuAc", "NeuAc"))), Map.entry("gd2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gd3", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm3", new ArrayList<String>(Arrays.asList("NeuAc", "Gal", "Glc"))), Map.entry("gm4", new ArrayList<String>(Arrays.asList("NeuAc", "Gal"))), Map.entry("gp1", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gq1", new ArrayList<String>(Arrays.asList("NeuAc", "Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt3", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))));
    protected static HashSet<String> SP_EXCEPTION_CLASSES = new HashSet<String>(Arrays.asList("Cer", "Ceramide", "Sphingosine", "So", "Sphinganine", "Sa", "SPH", "Sph", "LCB"));

    public LipidBaseParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        this.knownFunctionalGroups = knownFunctionalGroups;
    }

    protected void setLipidLevel(LipidLevel _level) {
        this.level = this.level.level < _level.level ? this.level : _level;
    }

    protected boolean spRegularLcb() {
        return !(Headgroup.getCategory(this.headGroup) != LipidCategory.SP || this.currentFa.getLipidFaBondType() != LipidFaBondType.LCB_REGULAR && this.currentFa.getLipidFaBondType() != LipidFaBondType.LCB_EXCEPTION || SP_EXCEPTION_CLASSES.contains(this.headGroup) && this.headgroupDecorators.isEmpty());
    }

    protected Headgroup prepareHeadgroupAndChecks() {
        int max_num_fa;
        String hg = this.headGroup.toLowerCase();
        if (GLYCO_TABLE.containsKey(hg)) {
            for (String carbohydrate : GLYCO_TABLE.get(hg)) {
                Object functional_group = null;
                try {
                    functional_group = this.knownFunctionalGroups.get(carbohydrate);
                }
                catch (Exception e) {
                    throw new LipidParsingException("Carbohydrate '" + carbohydrate + "' unknown");
                }
                ((FunctionalGroup)functional_group).getElements().put(Element.O, (Integer)((FunctionalGroup)functional_group).getElements().get((Object)Element.O) - 1);
                this.headgroupDecorators.add((HeadgroupDecorator)functional_group);
            }
            this.headGroup = "Cer";
        }
        Headgroup headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
        if (this.useHeadGroup) {
            return headgroup;
        }
        this.headGroup = headgroup.getClassName();
        int true_fa = 0;
        for (FattyAcid fa : this.faList) {
            true_fa += fa.getNumCarbon() > 0 || fa.getDoubleBonds().getNumDoubleBonds() > 0 ? 1 : 0;
        }
        int poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
        boolean can_be_lyso = LipidClasses.getInstance().size() > Headgroup.getClass("L" + this.headGroup) ? ((LipidClassMeta)LipidClasses.getInstance().get((int)Headgroup.getClass((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"L\u0001"}, (String)this.headGroup))))).specialCases.contains("Lyso") : false;
        LipidClassMeta l = (LipidClassMeta)LipidClasses.getInstance().get(Headgroup.getClass("LCL"));
        if ((true_fa + 1 == poss_fa || true_fa + 2 == poss_fa) && this.level != LipidLevel.SPECIES && headgroup.getLipidCategory() == LipidCategory.GP && can_be_lyso) {
            this.headGroup = true_fa + 1 == poss_fa ? "L" + this.headGroup : "DL" + this.headGroup;
            headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
            poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
        } else if ((true_fa + 1 == poss_fa || true_fa + 2 == poss_fa) && this.level != LipidLevel.SPECIES && headgroup.getLipidCategory() == LipidCategory.GL && this.headGroup.equals("TG")) {
            this.headGroup = true_fa + 1 == poss_fa ? "DG" : "MG";
            headgroup = new Headgroup(this.headGroup, this.headgroupDecorators, this.useHeadGroup);
            int n = poss_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).possibleNumFa : 0;
        }
        if (this.level == LipidLevel.SPECIES) {
            if (true_fa == 0 && poss_fa != 0) {
                throw new ConstraintViolationException("No fatty acyl information lipid class '" + headgroup.getHeadgroup() + "' provided.");
            }
        } else {
            if (true_fa != poss_fa && LipidLevel.isLevel(this.level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level)) {
                throw new ConstraintViolationException("Number of described fatty acyl chains (" + Integer.toString(true_fa) + ") not allowed for lipid class '" + headgroup.getHeadgroup() + "' (having " + Integer.toString(poss_fa) + " fatty aycl chains).");
            }
            if (((LipidClassMeta)LipidClasses.getInstance().get((int)Headgroup.getClass((String)this.headGroup))).specialCases.contains("Lyso") && true_fa > poss_fa) {
                throw new ConstraintViolationException("Number of described fatty acyl chains (" + Integer.toString(true_fa) + ") not allowed for lipid class '" + headgroup.getHeadgroup() + "' (having " + Integer.toString(poss_fa) + " fatty aycl chains).");
            }
        }
        if (((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).specialCases.contains("HC")) {
            this.faList.get(0).setLipidFaBondType(LipidFaBondType.ETHER);
        }
        if (((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).specialCases.contains("Amide")) {
            for (FattyAcid fatty : this.faList) {
                fatty.setLipidFaBondType(LipidFaBondType.AMIDE);
            }
        }
        int n = max_num_fa = LipidClasses.getInstance().size() > headgroup.getLipidClass() ? ((LipidClassMeta)LipidClasses.getInstance().get((int)headgroup.getLipidClass())).maxNumFa : 0;
        if (max_num_fa != this.faList.size()) {
            this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
        }
        if (this.faList.size() > 0 && headgroup.isSpException()) {
            this.faList.get(0).setType(LipidFaBondType.LCB_EXCEPTION);
        }
        return headgroup;
    }

    protected LipidSpecies assembleLipid(Headgroup headgroup) {
        for (FattyAcid fa : this.faList) {
            if (!fa.stereoInformationMissing()) continue;
            this.setLipidLevel(LipidLevel.FULL_STRUCTURE);
            break;
        }
        LipidSpecies ls = null;
        switch (this.level) {
            case COMPLETE_STRUCTURE: {
                ls = new LipidCompleteStructure(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case FULL_STRUCTURE: {
                ls = new LipidFullStructure(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case STRUCTURE_DEFINED: {
                ls = new LipidStructureDefined(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case SN_POSITION: {
                ls = new LipidSnPosition(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case MOLECULAR_SPECIES: {
                ls = new LipidMolecularSpecies(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
            case SPECIES: {
                ls = new LipidSpecies(headgroup, this.faList, this.knownFunctionalGroups);
                break;
            }
        }
        return ls;
    }
}

