/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;

public final class Headgroup {
    public static final HashMap<String, LipidCategory> StringCategory = new HashMap();
    public static final HashMap<String, Integer> StringClass = new HashMap();
    public static final HashMap<Integer, String> ClassString = new HashMap();
    public static final HashSet<String> exceptionHeadgroups = new HashSet<String>(Arrays.asList("Cer", "SPB"));
    private static final KnownFunctionalGroups knownFunctionalGroups = new KnownFunctionalGroups();
    private String headgroup;
    private LipidCategory lipidCategory;
    private int lipidClass;
    private boolean useHeadgroup;
    private ArrayList<HeadgroupDecorator> decorators = new ArrayList();
    private boolean spException;
    public static final Map<LipidCategory, String> CategoryString = Map.ofEntries(Map.entry(LipidCategory.NO_CATEGORY, "NO_CATEGORY"), Map.entry(LipidCategory.UNDEFINED, "UNDEFINED"), Map.entry(LipidCategory.GL, "GL"), Map.entry(LipidCategory.GP, "GP"), Map.entry(LipidCategory.SP, "SP"), Map.entry(LipidCategory.ST, "ST"), Map.entry(LipidCategory.FA, "FA"), Map.entry(LipidCategory.SL, "SL"));
    private static final Map<String, ArrayList<String>> GLYCO_TABLE = Map.ofEntries(Map.entry("ga2", new ArrayList<String>(Arrays.asList("GalNAc", "Gal", "Glc"))), Map.entry("gb3", new ArrayList<String>(Arrays.asList("Gal", "Gal", "Glc"))), Map.entry("gb4", new ArrayList<String>(Arrays.asList("GalNAc", "Gal", "Gal", "Glc"))), Map.entry("gd1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gd1a", new ArrayList<String>(Arrays.asList("Hex", "Hex", "Hex", "HexNAc", "NeuAc", "NeuAc"))), Map.entry("gd2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gd3", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "Gal", "Glc"))), Map.entry("gm3", new ArrayList<String>(Arrays.asList("NeuAc", "Gal", "Glc"))), Map.entry("gm4", new ArrayList<String>(Arrays.asList("NeuAc", "Gal"))), Map.entry("gp1", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gq1", new ArrayList<String>(Arrays.asList("NeuAc", "Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt1", new ArrayList<String>(Arrays.asList("Gal", "GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt2", new ArrayList<String>(Arrays.asList("GalNAc", "NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))), Map.entry("gt3", new ArrayList<String>(Arrays.asList("NeuAc", "NeuAc", "NeuAc", "Gal", "Glc"))));

    public Headgroup(String _headgroup) {
        this(_headgroup, null, false);
    }

    public Headgroup(String _headgroup, ArrayList<HeadgroupDecorator> _decorators, boolean _use_headgroup) {
        String hg = _headgroup.toLowerCase();
        if (GLYCO_TABLE.containsKey(hg) && !_use_headgroup) {
            for (String carbohydrate : GLYCO_TABLE.get(hg)) {
                FunctionalGroup functional_group = null;
                try {
                    functional_group = knownFunctionalGroups.get(carbohydrate);
                }
                catch (Exception e) {
                    throw new LipidParsingException("Carbohydrate '" + carbohydrate + "' unknown");
                }
                functional_group.getElements().put(Element.O, (Integer)functional_group.getElements().get((Object)Element.O) - 1);
                this.decorators.add((HeadgroupDecorator)functional_group);
            }
            _headgroup = "Cer";
        }
        this.headgroup = _headgroup;
        this.lipidCategory = Headgroup.getCategory(_headgroup);
        this.lipidClass = Headgroup.getClass(this.headgroup);
        this.useHeadgroup = _use_headgroup;
        if (_decorators != null) {
            for (HeadgroupDecorator hgd : _decorators) {
                this.decorators.add(hgd);
            }
        }
        this.spException = this.lipidCategory == LipidCategory.SP && exceptionHeadgroups.contains(((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).lipidClassName) && this.decorators.isEmpty();
    }

    public static LipidCategory getCategory(String _headgroup) {
        if (StringCategory.isEmpty()) {
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                LipidCategory category = lipid_class.lipidCategory;
                lipid_class.synonyms.forEach(hg -> StringCategory.put((String)hg, category));
            }
        }
        return StringCategory.containsKey(_headgroup) ? StringCategory.get(_headgroup) : LipidCategory.UNDEFINED;
    }

    public static int getClass(String _headgroup) {
        if (StringClass.isEmpty()) {
            int l_class = 0;
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                for (String hg : lipid_class.synonyms) {
                    StringClass.put(hg, l_class);
                }
                ++l_class;
            }
        }
        return StringClass.containsKey(_headgroup) ? StringClass.get(_headgroup) : 0;
    }

    public static String getClassString(int _lipid_class) {
        if (ClassString.isEmpty()) {
            int l_class = 0;
            for (LipidClassMeta lipid_class : LipidClasses.getInstance()) {
                ClassString.put(l_class++, lipid_class.synonyms.get(0));
            }
        }
        return ClassString.containsKey(_lipid_class) ? ClassString.get(_lipid_class) : "UNDEFINED";
    }

    @JsonGetter(value="lipidClass")
    public String getClassName() {
        return ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).lipidClassName;
    }

    public static String getCategoryString(LipidCategory _lipid_category) {
        return CategoryString.get((Object)_lipid_category);
    }

    public String getLipidString(LipidLevel level) {
        if (level == LipidLevel.CATEGORY) {
            return Headgroup.getCategoryString(this.lipidCategory);
        }
        String hgs = this.useHeadgroup ? this.headgroup : Headgroup.getClassString(this.lipidClass);
        StringBuilder headgoup_string = new StringBuilder();
        if (!LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level)) {
            ArrayList<HeadgroupDecorator> decoratorsTmp = new ArrayList<HeadgroupDecorator>();
            for (HeadgroupDecorator hgd : this.decorators) {
                if (hgd.isSuffix()) continue;
                HeadgroupDecorator hgd_copy = (HeadgroupDecorator)hgd.copy();
                hgd_copy.name = hgd_copy.name.replace("Gal", "Hex");
                hgd_copy.name = hgd_copy.name.replace("Glc", "Hex");
                hgd_copy.name = hgd_copy.name.replace("S(3')", "S");
                decoratorsTmp.add(hgd_copy);
            }
            Collections.sort(decoratorsTmp);
            for (int i = decoratorsTmp.size() - 1; i > 0; --i) {
                HeadgroupDecorator hge = (HeadgroupDecorator)decoratorsTmp.get(i);
                HeadgroupDecorator hgeBefore = (HeadgroupDecorator)decoratorsTmp.get(i - 1);
                if (!hge.getName().equals(hgeBefore.getName())) continue;
                hgeBefore.setCount(hgeBefore.getCount() + hge.getCount());
                decoratorsTmp.remove(i);
            }
            for (HeadgroupDecorator hge : decoratorsTmp) {
                headgoup_string.append(hge.toString(level));
            }
        } else {
            for (HeadgroupDecorator hgd : this.decorators) {
                if (hgd.isSuffix()) continue;
                headgoup_string.append(hgd.toString(level)).append("-");
            }
        }
        headgoup_string.append(hgs);
        for (HeadgroupDecorator hgd : this.decorators) {
            if (!hgd.isSuffix()) continue;
            headgoup_string.append(hgd.toString(level));
        }
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level) && this.lipidCategory == LipidCategory.SP && !this.spException) {
            headgoup_string.append("(1)");
        }
        return headgoup_string.toString();
    }

    @JsonIgnore
    public ElementTable getElements() {
        if (this.useHeadgroup || LipidClasses.getInstance().size() <= this.lipidClass) {
            throw new ConstraintViolationException("Element table cannot be computed for lipid '" + this.headgroup + "'");
        }
        ElementTable elements = ((LipidClassMeta)LipidClasses.getInstance().get((int)this.lipidClass)).elements.copy();
        this.decorators.forEach(hgd -> elements.add(hgd.computeAndCopyElements(), hgd.count));
        return elements;
    }

    @JsonGetter(value="name")
    public String getHeadgroup() {
        return this.headgroup;
    }

    public void setHeadgroup(String headgroup) {
        this.headgroup = headgroup;
    }

    public LipidCategory getLipidCategory() {
        return this.lipidCategory;
    }

    public void setLipidCategory(LipidCategory lipidCategory) {
        this.lipidCategory = lipidCategory;
    }

    @JsonIgnore
    public int getLipidClass() {
        return this.lipidClass;
    }

    public void setLipidClass(int lipidClass) {
        this.lipidClass = lipidClass;
    }

    @JsonIgnore
    public boolean isUseHeadgroup() {
        return this.useHeadgroup;
    }

    public void setUseHeadgroup(boolean useHeadgroup) {
        this.useHeadgroup = useHeadgroup;
    }

    @JsonIgnore
    public boolean isSpException() {
        return this.spException;
    }

    public void setSpException(boolean spException) {
        this.spException = spException;
    }

    @JsonIgnore
    public ArrayList<HeadgroupDecorator> getDecorators() {
        return this.decorators;
    }

    public void setDecorators(ArrayList<HeadgroupDecorator> decorators) {
        this.decorators = decorators;
    }
}

