/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.Arrays;
import java.util.List;
import org.lifstools.jgoslin.domain.ConstraintViolationException;

public enum LipidCategory {
    NO_CATEGORY("Unknown lipid category"),
    UNDEFINED("Undefined lipid category"),
    GL("Glycerolipids"),
    GP("Glycerophospholipids"),
    SP("Sphingolipids"),
    ST("Sterollipids"),
    FA("Fattyacyls"),
    PK("Polyketides"),
    SL("Saccharolipids");

    private final String fullName;

    private LipidCategory(String fullName) {
        this.fullName = fullName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public static LipidCategory forFullName(String fullName) {
        List<LipidCategory> matches = Arrays.asList(LipidCategory.values()).stream().filter(t -> t.getFullName().equalsIgnoreCase(fullName)).toList();
        if (matches.isEmpty()) {
            return UNDEFINED;
        }
        if (matches.size() > 1) {
            throw new ConstraintViolationException("Query string " + fullName + " found more than once in enum values! Please check enum definition: fullName is compared case insensitive!");
        }
        return matches.get(0);
    }
}

