/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.Collection;
import java.util.Collections;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidMolecularSpecies;

public class LipidSnPosition
extends LipidMolecularSpecies {
    public LipidSnPosition(Headgroup _headgroup, KnownFunctionalGroups knownFunctionalGroups) {
        this(_headgroup, Collections.emptyList(), knownFunctionalGroups);
    }

    public LipidSnPosition(Headgroup _headgroup, Collection<FattyAcid> _fa, KnownFunctionalGroups knownFunctionalGroups) {
        super(_headgroup, _fa, knownFunctionalGroups);
        this.info.setLevel(LipidLevel.SN_POSITION);
        int pos = 1;
        for (FattyAcid fatty_acid : this.faList) {
            fatty_acid.position = pos++;
        }
    }

    @Override
    public LipidLevel getLipidLevel() {
        return LipidLevel.SN_POSITION;
    }

    @Override
    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    @Override
    public String getLipidString(LipidLevel level) {
        switch (level) {
            case NO_LEVEL: 
            case SN_POSITION: {
                return this.buildLipidSubspeciesName(LipidLevel.SN_POSITION);
            }
            case MOLECULAR_SPECIES: 
            case CATEGORY: 
            case CLASS: 
            case SPECIES: {
                return super.getLipidString(level);
            }
        }
        throw new IllegalArgumentException("LipidSnPosition does not know how to create a lipid string for level " + level.toString());
    }
}

