/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidCategory;
import org.lifstools.jgoslin.domain.LipidClassMeta;
import org.lifstools.jgoslin.domain.LipidClasses;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidSpeciesInfo;

public class LipidSpecies {
    protected Headgroup headGroup;
    protected LipidSpeciesInfo info;
    protected HashMap<String, FattyAcid> fa = new HashMap();
    protected ArrayList<FattyAcid> faList = new ArrayList();

    public LipidSpecies(Headgroup _headgroup, KnownFunctionalGroups knownFunctionalGroups) {
        this(_headgroup, Collections.emptyList(), knownFunctionalGroups);
    }

    public LipidSpecies(Headgroup _headGroup, Collection<FattyAcid> _fa, KnownFunctionalGroups knownFunctionalGroups) {
        this.headGroup = _headGroup;
        this.info = new LipidSpeciesInfo(this.headGroup.getLipidClass(), knownFunctionalGroups);
        this.info.setLevel(LipidLevel.SPECIES);
        if (_fa != null && !_fa.isEmpty()) {
            int i = 0;
            FattyAcid fattyAcid = _fa.iterator().next();
            boolean fa_it = _fa.size() > 0 && (fattyAcid.lipidFaBondType == LipidFaBondType.LCB_EXCEPTION || fattyAcid.lipidFaBondType == LipidFaBondType.LCB_REGULAR);
            for (FattyAcid fatty_acid : _fa) {
                fatty_acid.name = fa_it && i == 0 ? "LCB" : "FA" + String.valueOf(i + 1 - (fa_it ? 1 : 0));
                fatty_acid.position = -1;
                this.info.add(fatty_acid);
                ++i;
            }
        }
    }

    public LipidLevel getLipidLevel() {
        return LipidLevel.SPECIES;
    }

    public LipidSpeciesInfo getInfo() {
        return this.info;
    }

    public Headgroup getHeadGroup() {
        return this.headGroup;
    }

    public String getLipidString() {
        return this.getLipidString(LipidLevel.NO_LEVEL);
    }

    public String getLipidString(LipidLevel level) {
        switch (level) {
            case UNDEFINED_LEVEL: {
                throw new IllegalArgumentException("LipidSpecies does not know how to create a lipid string for level " + level.toString());
            }
            case CLASS: 
            case CATEGORY: {
                return this.headGroup.getLipidString(level);
            }
            case NO_LEVEL: 
            case SPECIES: {
                StringBuilder lipid_string = new StringBuilder();
                lipid_string.append(this.headGroup.getLipidString(level));
                if ((Integer)this.info.getElements().get((Object)Element.C) > 0 || this.info.numCarbon > 0) {
                    LipidSpeciesInfo lsi = this.info.copy();
                    for (HeadgroupDecorator decorator : this.headGroup.getDecorators()) {
                        if (!decorator.getName().equals("decorator_alkyl") && !decorator.getName().equals("decorator_acyl")) continue;
                        ElementTable e = decorator.computeAndCopyElements();
                        lsi.numCarbon += ((Integer)e.get((Object)Element.C)).intValue();
                        lsi.doubleBonds.setNumDoubleBonds(lsi.doubleBonds.getNumDoubleBonds() + decorator.getNDoubleBonds());
                    }
                    lipid_string.append(this.headGroup.getLipidCategory() != LipidCategory.ST ? " " : "/").append(lsi.toString());
                }
                return lipid_string.toString();
            }
        }
        throw new IllegalArgumentException("LipidSpecies does not know how to create a lipid string for level " + level.toString());
    }

    public String getExtendedClass() {
        boolean special_case = this.info.numCarbon > 0 ? this.headGroup.getLipidCategory() == LipidCategory.GP : false;
        String class_name = this.headGroup.getClassName();
        if (special_case && (this.info.extendedClass == LipidFaBondType.ETHER_PLASMANYL || this.info.extendedClass == LipidFaBondType.ETHER_UNSPECIFIED)) {
            return class_name + "-O";
        }
        if (special_case && this.info.extendedClass == LipidFaBondType.ETHER_PLASMENYL) {
            return class_name + "-P";
        }
        return class_name;
    }

    public ArrayList<FattyAcid> getFaList() {
        return this.faList;
    }

    @JsonIgnore
    public ElementTable getElements() {
        switch (this.info.getLevel()) {
            case SPECIES: 
            case COMPLETE_STRUCTURE: 
            case FULL_STRUCTURE: 
            case STRUCTURE_DEFINED: 
            case SN_POSITION: 
            case MOLECULAR_SPECIES: {
                break;
            }
            default: {
                throw new LipidException("Element table cannot be computed for lipid level " + this.info.getLevel().toString());
            }
        }
        if (this.headGroup.isUseHeadgroup()) {
            throw new LipidException("Element table cannot be computed for lipid level " + this.info.getLevel().toString());
        }
        ElementTable elements = this.headGroup.getElements();
        elements.add(this.info.getElements());
        LipidClassMeta meta = (LipidClassMeta)LipidClasses.getInstance().get(this.headGroup.getLipidClass());
        int additional_fa = meta.possibleNumFa;
        int remaining_H = meta.maxNumFa - additional_fa;
        int hydrochain = meta.specialCases.contains("HC") ? 1 : 0;
        elements.put(Element.O, (Integer)elements.get((Object)Element.O) - (-additional_fa + this.info.numEthers + (this.headGroup.isSpException() ? 1 : 0) + hydrochain));
        elements.put(Element.H, (Integer)elements.get((Object)Element.H) + (-additional_fa + remaining_H + 2 * this.info.numEthers + 2 * hydrochain));
        if (meta.specialCases.contains("Amide")) {
            elements.put(Element.O, (Integer)elements.get((Object)Element.O) - meta.maxNumFa);
            elements.put(Element.H, (Integer)elements.get((Object)Element.H) + meta.maxNumFa);
        }
        return elements;
    }
}

