/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.Elements;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;

public final class Cycle
extends FunctionalGroup {
    private int cycle;
    private int start;
    private int end;
    private final ArrayList<Element> bridgeChain;

    public Cycle(int _cycle, KnownFunctionalGroups knownFunctionalGroups) {
        this(_cycle, -1, -1, null, null, null, knownFunctionalGroups);
    }

    public Cycle(int _cycle, int _start, int _end, KnownFunctionalGroups knownFunctionalGroups) {
        this(_cycle, _start, _end, null, null, null, knownFunctionalGroups);
    }

    public Cycle(int _cycle, int _start, int _end, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, KnownFunctionalGroups knownFunctionalGroups) {
        this(_cycle, _start, _end, null, _functional_groups, null, knownFunctionalGroups);
    }

    public Cycle(int _cycle, int _start, int _end, DoubleBonds _double_bonds, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, KnownFunctionalGroups knownFunctionalGroups) {
        this(_cycle, _start, _end, _double_bonds, _functional_groups, null, knownFunctionalGroups);
    }

    public Cycle(int _cycle, int _start, int _end, DoubleBonds _double_bonds, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, ArrayList<Element> _bridge_chain, KnownFunctionalGroups knownFunctionalGroups) {
        super("cy", _start, 1, _double_bonds, false, "", false, null, _functional_groups, knownFunctionalGroups);
        this.cycle = _cycle;
        this.start = _start;
        this.end = _end;
        this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) - 2);
        this.bridgeChain = _bridge_chain == null ? new ArrayList() : _bridge_chain;
    }

    @Override
    public FunctionalGroup copy() {
        DoubleBonds db = this.doubleBonds.copy();
        HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>();
        this.functionalGroups.entrySet().stream().map(kv -> {
            fg.put((String)kv.getKey(), new ArrayList());
            return kv;
        }).forEachOrdered(kv -> ((ArrayList)kv.getValue()).forEach(func_group -> ((ArrayList)fg.get(kv.getKey())).add(func_group.copy())));
        ArrayList<Element> bc = new ArrayList<Element>();
        for (Element e : this.bridgeChain) {
            bc.add(e);
        }
        return new Cycle(this.cycle, this.start, this.end, db, fg, bc, this.knownFunctionalGroups);
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public ArrayList<Element> getBridgeChain() {
        return this.bridgeChain;
    }

    @Override
    public int getNDoubleBonds() throws ConstraintViolationException {
        return super.getNDoubleBonds() + 1;
    }

    @Override
    public void addPosition(int pos) {
        this.start += this.start >= pos ? 1 : 0;
        this.end += this.end >= pos ? 1 : 0;
        super.addPosition(pos);
    }

    public void rearrangeFunctionalGroups(FunctionalGroup parent, int shift) {
        for (Map.Entry<Integer, String> entry : this.doubleBonds.doubleBondPositions.entrySet()) {
            parent.doubleBonds.doubleBondPositions.put(entry.getKey(), entry.getValue());
        }
        this.doubleBonds = new DoubleBonds();
        for (Map.Entry<Integer, String> entry : this.functionalGroups.entrySet()) {
            if (!parent.functionalGroups.containsKey(entry.getKey())) {
                parent.functionalGroups.put((String)((Object)entry.getKey()), new ArrayList());
            }
            parent.functionalGroups.get(entry.getKey()).addAll((Collection)this.functionalGroups.get(entry.getKey()));
        }
        this.functionalGroups = new HashMap();
        this.shiftPositions(shift);
        parent.doubleBonds.doubleBondPositions.entrySet().stream().filter(kv -> this.start <= (Integer)kv.getKey() && (Integer)kv.getKey() <= this.end).forEachOrdered(kv -> this.doubleBonds.doubleBondPositions.put((Integer)kv.getKey(), (String)kv.getValue()));
        this.doubleBonds.setNumDoubleBonds(this.doubleBonds.doubleBondPositions.size());
        this.doubleBonds.doubleBondPositions.entrySet().forEach(kv -> parent.doubleBonds.doubleBondPositions.remove(kv.getKey()));
        parent.doubleBonds.setNumDoubleBonds(parent.doubleBonds.doubleBondPositions.size());
        HashSet<String> remove_list = new HashSet<String>();
        for (Map.Entry<String, ArrayList<FunctionalGroup>> kv3 : parent.functionalGroups.entrySet()) {
            ArrayList<Integer> remove_item = new ArrayList<Integer>();
            int i = 0;
            for (FunctionalGroup func_group : kv3.getValue()) {
                if (this.start <= func_group.getPosition() && func_group.getPosition() <= this.end && func_group != this) {
                    if (!this.functionalGroups.containsKey(kv3.getKey())) {
                        this.functionalGroups.put(kv3.getKey(), new ArrayList());
                    }
                    ((ArrayList)this.functionalGroups.get(kv3.getKey())).add(func_group);
                    remove_item.add(i);
                }
                ++i;
            }
            while (remove_item.size() > 0) {
                int pos = (Integer)remove_item.get(remove_item.size() - 1);
                remove_item.remove(remove_item.size() - 1);
                kv3.getValue().remove(pos);
            }
            if (!kv3.getValue().isEmpty()) continue;
            remove_list.add(kv3.getKey());
        }
        for (String fg : remove_list) {
            parent.functionalGroups.remove(fg);
        }
    }

    @Override
    public void shiftPositions(int shift) {
        super.shiftPositions(shift);
        this.start += shift;
        this.end += shift;
        DoubleBonds db = new DoubleBonds();
        for (Map.Entry<Integer, String> kv : this.doubleBonds.doubleBondPositions.entrySet()) {
            db.doubleBondPositions.put(kv.getKey() + shift, kv.getValue());
        }
        db.setNumDoubleBonds(db.doubleBondPositions.size());
        this.doubleBonds = db;
    }

    @Override
    public void computeElements() {
        this.elements = new ElementTable();
        this.elements.put(Element.H, -2 - 2 * this.doubleBonds.getNumDoubleBonds());
        for (Element chain_element : this.bridgeChain) {
            try {
                switch (chain_element) {
                    case C: {
                        this.elements.put(Element.C, (Integer)this.elements.get((Object)Element.C) + 1);
                        this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) + 2);
                        break;
                    }
                    case N: {
                        this.elements.put(Element.N, (Integer)this.elements.get((Object)Element.N) + 1);
                        this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) + 1);
                        break;
                    }
                    case P: {
                        this.elements.put(Element.P, (Integer)this.elements.get((Object)Element.P) + 1);
                        this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) + 1);
                        break;
                    }
                    case As: {
                        this.elements.put(Element.As, (Integer)this.elements.get((Object)Element.As) + 1);
                        this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) + 1);
                        break;
                    }
                    case O: {
                        this.elements.put(Element.O, (Integer)this.elements.get((Object)Element.O) + 1);
                        break;
                    }
                    case S: {
                        this.elements.put(Element.S, (Integer)this.elements.get((Object)Element.S) + 1);
                    }
                }
            }
            catch (Exception e) {
                throw new ConstraintViolationException("Element '" + Elements.ELEMENT_SHORTCUT.get((Object)chain_element) + "' cannot be part of a cycle bridge", e);
            }
        }
        if (this.start != -1 && this.end != -1) {
            int n = Math.max(0, this.cycle - (this.end - this.start + 1 + this.bridgeChain.size()));
            this.elements.put(Element.C, (Integer)this.elements.get((Object)Element.C) + n);
            this.elements.put(Element.H, (Integer)this.elements.get((Object)Element.H) + 2 * n);
        }
    }

    @Override
    public String toString(LipidLevel level) {
        StringBuilder cycle_string = new StringBuilder();
        cycle_string.append("[");
        if (this.start != -1 && LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
            cycle_string.append(this.start).append("-").append(this.end);
        }
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level) && this.bridgeChain.size() > 0) {
            for (Element e : this.bridgeChain) {
                cycle_string.append(Elements.ELEMENT_SHORTCUT.get((Object)e));
            }
        }
        cycle_string.append("cy").append(this.cycle);
        cycle_string.append(":").append(this.doubleBonds.getNumDoubleBonds());
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level | LipidLevel.STRUCTURE_DEFINED.level) && this.doubleBonds.doubleBondPositions.size() > 0) {
            int i = 0;
            cycle_string.append("(");
            ArrayList<Integer> sorted = new ArrayList<Integer>(this.doubleBonds.doubleBondPositions.keySet());
            Collections.sort(sorted, (a, b) -> a - b);
            for (int key : sorted) {
                String value = this.doubleBonds.doubleBondPositions.get(key);
                if (i++ > 0) {
                    cycle_string.append(",");
                }
                if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
                    cycle_string.append(key).append(value);
                    continue;
                }
                cycle_string.append(key);
            }
            cycle_string.append(")");
        }
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
            fg_names = new ArrayList(this.functionalGroups.keySet());
            Collections.sort(fg_names, (a, b) -> a.toLowerCase().compareTo(b.toLowerCase()));
            for (String fg : fg_names) {
                ArrayList fg_list = (ArrayList)this.functionalGroups.get(fg);
                if (fg_list.isEmpty()) continue;
                Collections.sort(fg_list, (a, b) -> a.getPosition() - b.getPosition());
                int i = 0;
                cycle_string.append(";");
                for (FunctionalGroup func_group : fg_list) {
                    if (i++ > 0) {
                        cycle_string.append(",");
                    }
                    cycle_string.append(func_group.toString(level));
                }
            }
        } else if (level == LipidLevel.STRUCTURE_DEFINED) {
            fg_names = new ArrayList(this.functionalGroups.keySet());
            Collections.sort(fg_names, (a, b) -> a.toLowerCase().compareTo(b.toLowerCase()));
            for (String fg : fg_names) {
                ArrayList fg_list = (ArrayList)this.functionalGroups.get(fg);
                if (fg_list.size() <= 0) continue;
                if (fg_list.size() == 1 && ((FunctionalGroup)fg_list.get(0)).getCount() == 1) {
                    cycle_string.append(";").append(((FunctionalGroup)fg_list.get(0)).toString(level));
                    continue;
                }
                int fg_count = 0;
                for (FunctionalGroup func_group : fg_list) {
                    fg_count += func_group.getCount();
                }
                if (fg_count > 1) {
                    cycle_string.append(";(").append(fg).append(")").append(fg_count);
                    continue;
                }
                cycle_string.append(";").append(fg);
            }
        }
        cycle_string.append("]");
        if (this.getStereochemistry().length() > 0) {
            cycle_string.append("[").append(this.getStereochemistry()).append("]");
        }
        return cycle_string.toString();
    }
}

