/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.Element;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidLevel;

public class FunctionalGroup {
    protected String name;
    protected int position = -1;
    protected int count;
    protected String stereochemistry;
    protected String ringStereo;
    protected DoubleBonds doubleBonds;
    protected boolean atomic;
    protected boolean stereoBound;
    protected ElementTable elements;
    protected HashMap<String, ArrayList<FunctionalGroup>> functionalGroups;
    protected KnownFunctionalGroups knownFunctionalGroups;

    public FunctionalGroup(String _name, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, -1, 1, null, false, "", false, null, null, knownFunctionalGroups);
    }

    public FunctionalGroup(String _name, int _position, int _count, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _position, _count, null, false, "", false, null, null, knownFunctionalGroups);
    }

    public FunctionalGroup(String _name, int _position, int _count, DoubleBonds _double_bonds, boolean _is_atomic, String _stereochemistry, boolean _stereoBound, ElementTable _elements, KnownFunctionalGroups knownFunctionalGroups) {
        this(_name, _position, _count, _double_bonds, _is_atomic, _stereochemistry, _stereoBound, _elements, null, knownFunctionalGroups);
    }

    public FunctionalGroup(String _name, int _position, int _count, DoubleBonds _double_bonds, boolean _is_atomic, String _stereochemistry, boolean _stereoBound, ElementTable _elements, HashMap<String, ArrayList<FunctionalGroup>> _functional_groups, KnownFunctionalGroups knownFunctionalGroups) {
        this.name = _name;
        this.position = _position;
        this.count = _count;
        this.stereochemistry = _stereochemistry;
        this.ringStereo = "";
        this.doubleBonds = _double_bonds != null ? _double_bonds : new DoubleBonds(0);
        this.atomic = _is_atomic;
        this.stereoBound = _stereoBound;
        this.elements = _elements != null ? _elements : new ElementTable();
        this.functionalGroups = _functional_groups != null ? _functional_groups : new HashMap();
        this.knownFunctionalGroups = knownFunctionalGroups;
    }

    public FunctionalGroup copy() {
        DoubleBonds db = this.doubleBonds.copy();
        HashMap<String, ArrayList<FunctionalGroup>> fg = new HashMap<String, ArrayList<FunctionalGroup>>();
        this.functionalGroups.entrySet().stream().map(kv -> {
            fg.put((String)kv.getKey(), new ArrayList());
            return kv;
        }).forEachOrdered(kv -> ((ArrayList)kv.getValue()).forEach(func_group -> ((ArrayList)fg.get(kv.getKey())).add(func_group.copy())));
        ElementTable e = new ElementTable();
        this.elements.entrySet().forEach(kv -> e.put((Element)((Object)((Object)kv.getKey())), (Integer)kv.getValue()));
        FunctionalGroup func_group_new = new FunctionalGroup(this.name, this.position, this.count, db, this.atomic, this.stereochemistry, this.stereoBound, e, fg, this.knownFunctionalGroups);
        func_group_new.ringStereo = this.ringStereo;
        return func_group_new;
    }

    public boolean stereoInformationMissing() {
        boolean missing = this.stereoBound && this.stereochemistry.isEmpty();
        for (ArrayList<FunctionalGroup> fgList : this.functionalGroups.values()) {
            for (FunctionalGroup fg : fgList) {
                missing |= fg.stereoInformationMissing();
            }
        }
        return missing;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStereoBound(boolean stereoBound) {
        this.stereoBound = stereoBound;
    }

    public boolean getStereoBound() {
        return this.stereoBound;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    @JsonIgnore
    public String getStereochemistry() {
        return this.stereochemistry;
    }

    public void setStereochemistry(String stereochemistry) {
        this.stereochemistry = stereochemistry;
    }

    @JsonIgnore
    public String getRingStereo() {
        return this.ringStereo;
    }

    public void setRingStereo(String ringStereo) {
        this.ringStereo = ringStereo;
    }

    public DoubleBonds getDoubleBonds() {
        return this.doubleBonds;
    }

    public void setDoubleBonds(DoubleBonds doubleBonds) {
        this.doubleBonds = doubleBonds;
    }

    public void setAtomic(boolean atomic) {
        this.atomic = atomic;
    }

    @JsonIgnore
    public boolean isAtomic() {
        return this.atomic;
    }

    @JsonIgnore
    public ElementTable getElements() {
        return this.elements;
    }

    public void setElements(ElementTable elements) {
        this.elements = elements;
    }

    @JsonIgnore
    public ElementTable computeAndCopyElements() {
        this.computeElements();
        ElementTable _elements = this.elements.copy();
        _elements.add(this.getFunctionalGroupElements());
        return _elements;
    }

    public void shiftPositions(int shift) {
        this.position += shift;
        this.functionalGroups.entrySet().forEach(kv -> ((ArrayList)kv.getValue()).forEach(fg -> fg.shiftPositions(shift)));
    }

    public Integer getTotalFunctionalGroupCount(String functionalGroup) {
        if ("[X]".equals(functionalGroup)) {
            return 0;
        }
        if (this.functionalGroups.containsKey(functionalGroup)) {
            return this.functionalGroups.get(functionalGroup).stream().map(fg -> fg.getCount()).reduce(0, Integer::sum);
        }
        return 0;
    }

    public Map<String, ArrayList<FunctionalGroup>> getFunctionalGroups() {
        HashMap<String, ArrayList<FunctionalGroup>> mapCopy = new HashMap<String, ArrayList<FunctionalGroup>>(this.functionalGroups);
        mapCopy.remove("[X]");
        return mapCopy;
    }

    @JsonIgnore
    public Map<String, ArrayList<FunctionalGroup>> getFunctionalGroupsInternal() {
        return this.functionalGroups;
    }

    public void setFunctionalGroups(HashMap<String, ArrayList<FunctionalGroup>> functionalGroups) {
        this.functionalGroups = functionalGroups;
    }

    @JsonIgnore
    public ElementTable getFunctionalGroupElements() {
        ElementTable _elements = new ElementTable();
        this.functionalGroups.entrySet().forEach(kv -> ((ArrayList)kv.getValue()).forEach(func_group -> _elements.add(func_group.computeAndCopyElements(), func_group.count)));
        return _elements;
    }

    public void computeElements() {
        this.functionalGroups.entrySet().forEach(kv -> ((ArrayList)kv.getValue()).forEach(func_group -> func_group.computeElements()));
    }

    public String toString(LipidLevel level) {
        Object fg_string = "";
        if (LipidLevel.isLevel(level, LipidLevel.COMPLETE_STRUCTURE.level | LipidLevel.FULL_STRUCTURE.level)) {
            fg_string = '0' <= this.name.charAt(0) && this.name.charAt(0) <= '9' ? (this.position > -1 ? Integer.toString(this.position) + this.ringStereo + "(" + this.name + ")" : this.name) : (this.position > -1 ? Integer.toString(this.position) + this.ringStereo + this.name : this.name);
        } else {
            Object object = fg_string = this.count > 1 ? "(" + this.name + ")" + Integer.toString(this.count) : this.name;
        }
        if (this.stereochemistry.length() > 0 && level == LipidLevel.COMPLETE_STRUCTURE) {
            fg_string = (String)fg_string + "[" + this.stereochemistry + "]";
        }
        return fg_string;
    }

    public int getNDoubleBonds() throws ConstraintViolationException {
        int db = this.count * this.doubleBonds.getNumDoubleBonds();
        for (Map.Entry<String, ArrayList<FunctionalGroup>> kv : this.functionalGroups.entrySet()) {
            for (FunctionalGroup func_group : kv.getValue()) {
                db += func_group.getNDoubleBonds();
            }
        }
        return db;
    }

    public void addPosition(int pos) {
        this.position += this.position >= pos ? 1 : 0;
        this.functionalGroups.entrySet().forEach(kv -> ((ArrayList)kv.getValue()).forEach(fg -> fg.addPosition(pos)));
    }
}

