/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.domain;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.lifstools.jgoslin.domain.ConstraintViolationException;
import org.lifstools.jgoslin.domain.DoubleBonds;
import org.lifstools.jgoslin.domain.ElementTable;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.StringFunctions;
import org.lifstools.jgoslin.parser.SumFormulaParser;
import org.lifstools.jgoslin.parser.SumFormulaParserEventHandler;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public final class KnownFunctionalGroups
extends HashMap<String, FunctionalGroup> {
    public static final int UNDEFINED_CLASS = 0;
    private final HashMap<String, ArrayList<Integer>> trivialMediators = new HashMap();

    private void loadData(List<String> lines, List<String> linesTM, SumFormulaParser sumFormulaParser) {
        ArrayList<String> tokens;
        int lineCounter = 0;
        ArrayList<ArrayList<String>> functional_data = new ArrayList<ArrayList<String>>();
        HashSet<String> functional_data_set = new HashSet<String>();
        for (String line : linesTM) {
            if (line.isEmpty() || (tokens = StringFunctions.splitString(line, '\t', '\"', true)).size() != 2 || this.containsKey(tokens.get(0))) continue;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (String pos : StringFunctions.splitString(tokens.get(1), ',', '\"', true)) {
                arrayList.add(Integer.parseInt(pos));
            }
            this.trivialMediators.put(tokens.get(0), arrayList);
        }
        for (String line : lines) {
            if (lineCounter++ == 0) continue;
            tokens = StringFunctions.splitString(line, ',', '\"', true);
            String string = tokens.get(1);
            if (functional_data_set.contains(string)) {
                throw new ConstraintViolationException("Error: functional group '" + string + "' occurs multiple times in file!");
            }
            functional_data.add(tokens);
            functional_data_set.add(string);
        }
        SumFormulaParser sfp = sumFormulaParser;
        SumFormulaParserEventHandler handler = sfp.newEventHandler();
        for (ArrayList arrayList : functional_data) {
            arrayList.add((String)arrayList.get(1));
            for (int i = 7; i < arrayList.size(); ++i) {
                ElementTable et;
                ElementTable elementTable = et = ((String)arrayList.get(2)).length() > 0 ? sfp.parse((String)arrayList.get(2), handler) : new ElementTable();
                if (((String)arrayList.get(0)).equals("FG")) {
                    this.put((String)arrayList.get(i), new FunctionalGroup((String)arrayList.get(1), -1, 1, new DoubleBonds(Integer.valueOf((String)arrayList.get(3))), ((String)arrayList.get(4)).equals("1"), "", ((String)arrayList.get(5)).equals("1"), et, this));
                    continue;
                }
                this.put((String)arrayList.get(i), new HeadgroupDecorator((String)arrayList.get(1), -1, 1, et, this));
            }
        }
    }

    public KnownFunctionalGroups() {
        this(StringFunctions.getResourceAsStringList((Resource)new ClassPathResource("functional-groups.csv")), new SumFormulaParser());
    }

    public KnownFunctionalGroups(List<String> lines, SumFormulaParser sumFormulaParser) {
        this.loadData(lines, StringFunctions.getResourceAsStringList((Resource)new ClassPathResource("trivial_mediators.csv")), sumFormulaParser);
    }

    public FunctionalGroup get(String s) {
        return ((FunctionalGroup)super.get(s)).copy();
    }

    public HashMap<String, ArrayList<Integer>> getTmDb() {
        return this.trivialMediators;
    }

    public ArrayList<Integer> db(String s) {
        return this.trivialMediators.get(s);
    }
}

