/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jgoslin.parser;

import java.util.ArrayList;
import java.util.Map;
import org.lifstools.jgoslin.domain.Adduct;
import org.lifstools.jgoslin.domain.FattyAcid;
import org.lifstools.jgoslin.domain.FunctionalGroup;
import org.lifstools.jgoslin.domain.Headgroup;
import org.lifstools.jgoslin.domain.HeadgroupDecorator;
import org.lifstools.jgoslin.domain.KnownFunctionalGroups;
import org.lifstools.jgoslin.domain.LipidAdduct;
import org.lifstools.jgoslin.domain.LipidException;
import org.lifstools.jgoslin.domain.LipidFaBondType;
import org.lifstools.jgoslin.domain.LipidLevel;
import org.lifstools.jgoslin.domain.LipidParsingException;
import org.lifstools.jgoslin.parser.LipidBaseParserEventHandler;
import org.lifstools.jgoslin.parser.TreeNode;

public class SwissLipidsParserEventHandler
extends LipidBaseParserEventHandler {
    private int dbPosition;
    private String dbCistrans;
    private int suffixNumber;

    public SwissLipidsParserEventHandler(KnownFunctionalGroups knownFunctionalGroups) {
        super(knownFunctionalGroups);
        try {
            this.registeredEvents = Map.ofEntries(Map.entry("lipid_pre_event", this::resetParser), Map.entry("lipid_post_event", this::buildLipid), Map.entry("adduct_info_pre_event", this::newAdduct), Map.entry("adduct_pre_event", this::addAdduct), Map.entry("charge_pre_event", this::addCharge), Map.entry("charge_sign_pre_event", this::addChargeSign), Map.entry("fa_hg_pre_event", this::setHeadGroupName), Map.entry("gl_hg_pre_event", this::setHeadGroupName), Map.entry("gl_molecular_hg_pre_event", this::setHeadGroupName), Map.entry("mediator_pre_event", this::mediatorEvent), Map.entry("gl_mono_hg_pre_event", this::setHeadGroupName), Map.entry("pl_hg_pre_event", this::setHeadGroupName), Map.entry("pl_three_hg_pre_event", this::setHeadGroupName), Map.entry("pl_four_hg_pre_event", this::setHeadGroupName), Map.entry("sl_hg_pre_event", this::setHeadGroupName), Map.entry("st_species_hg_pre_event", this::setHeadGroupName), Map.entry("st_sub1_hg_pre_event", this::setHeadGroupName), Map.entry("st_sub2_hg_pre_event", this::setHeadGroupNameSe), Map.entry("fa_species_pre_event", this::setSpeciesLevel), Map.entry("gl_molecular_pre_event", this::setMolecularLevel), Map.entry("unsorted_fa_separator_pre_event", this::setMolecularLevel), Map.entry("fa2_unsorted_pre_event", this::setMolecularLevel), Map.entry("fa3_unsorted_pre_event", this::setMolecularLevel), Map.entry("fa4_unsorted_pre_event", this::setMolecularLevel), Map.entry("db_single_position_pre_event", this::setIsomericLevel), Map.entry("db_single_position_post_event", this::addDbPosition), Map.entry("db_position_number_pre_event", this::addDbPositionNumber), Map.entry("cistrans_pre_event", this::addCistrans), Map.entry("lcb_pre_event", this::newLcb), Map.entry("lcb_post_event", this::cleanLcb), Map.entry("fa_pre_event", this::newFa), Map.entry("fa_post_event", this::appendFa), Map.entry("ether_pre_event", this::addEther), Map.entry("hydroxyl_pre_event", this::addHydroxyl), Map.entry("db_count_pre_event", this::addDoubleBonds), Map.entry("carbon_pre_event", this::addCarbon), Map.entry("sl_lcb_species_pre_event", this::setSpeciesLevel), Map.entry("st_species_fa_post_event", this::setSpeciesFa), Map.entry("fa_lcb_suffix_type_pre_event", this::addFaLcbSuffixType), Map.entry("fa_lcb_suffix_number_pre_event", this::addSuffixNumber), Map.entry("pl_three_post_event", this::setNape));
        }
        catch (Exception e) {
            throw new LipidParsingException("Cannot initialize LipidMapsParserEventHandler.");
        }
    }

    @Override
    protected void resetParser(TreeNode node) {
        this.content = null;
        this.level = LipidLevel.FULL_STRUCTURE;
        this.adduct = null;
        this.headGroup = "";
        this.lcb = null;
        this.faList.clear();
        this.currentFa = null;
        this.useHeadGroup = false;
        this.dbPosition = 0;
        this.dbCistrans = "";
        this.headgroupDecorators.clear();
        this.suffixNumber = -1;
    }

    private void setIsomericLevel(TreeNode node) {
        this.dbPosition = 0;
        this.dbCistrans = "";
    }

    private void addDbPosition(TreeNode node) {
        if (this.currentFa != null) {
            this.currentFa.getDoubleBonds().getDoubleBondPositions().put(this.dbPosition, this.dbCistrans);
            if (!this.dbCistrans.equals("E") && !this.dbCistrans.equals("Z")) {
                this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
            }
        }
    }

    private void setNape(TreeNode node) {
        this.headGroup = "PE-N";
        HeadgroupDecorator hgd = new HeadgroupDecorator("decorator_acyl", -1, 1, null, true, this.knownFunctionalGroups);
        this.headgroupDecorators.add(hgd);
        hgd.getFunctionalGroupsInternal().put("decorator_acyl", new ArrayList());
        hgd.getFunctionalGroupsInternal().get("decorator_acyl").add((FunctionalGroup)this.faList.get(this.faList.size() - 1));
        this.faList.remove(this.faList.size() - 1);
    }

    private void addDbPositionNumber(TreeNode node) {
        this.dbPosition = node.getInt();
    }

    private void addCistrans(TreeNode node) {
        this.dbCistrans = node.getText();
    }

    private void setHeadGroupName(TreeNode node) {
        this.headGroup = node.getText();
    }

    private void setHeadGroupNameSe(TreeNode node) {
        this.headGroup = node.getText().replace("(", " ");
    }

    private void setSpeciesLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.SPECIES);
    }

    private void setMolecularLevel(TreeNode node) {
        this.setLipidLevel(LipidLevel.MOLECULAR_SPECIES);
    }

    private void mediatorEvent(TreeNode node) {
        this.useHeadGroup = true;
        this.headGroup = node.getText();
    }

    private void newFa(TreeNode node) {
        this.currentFa = new FattyAcid("FA", this.knownFunctionalGroups);
    }

    private void newLcb(TreeNode node) {
        this.lcb = new FattyAcid("LCB", this.knownFunctionalGroups);
        this.lcb.setType(LipidFaBondType.LCB_REGULAR);
        this.currentFa = this.lcb;
        this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
    }

    private void cleanLcb(TreeNode node) {
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.currentFa = null;
    }

    private void appendFa(TreeNode node) {
        if (this.currentFa.getDoubleBonds().getNumDoubleBonds() < 0) {
            throw new LipidException("Double bond count does not match with number of double bond positions");
        }
        if (this.currentFa.getDoubleBonds().getDoubleBondPositions().isEmpty() && this.currentFa.getDoubleBonds().getNumDoubleBonds() > 0) {
            this.setLipidLevel(LipidLevel.SN_POSITION);
        }
        this.faList.add(this.currentFa);
        this.currentFa = null;
    }

    private void buildLipid(TreeNode node) {
        if (this.lcb != null) {
            this.faList.add(0, this.lcb);
        }
        Headgroup headgroup = this.prepareHeadgroupAndChecks();
        LipidAdduct lipid = new LipidAdduct(this.assembleLipid(headgroup), this.adduct);
        this.content = lipid;
    }

    private void addEther(TreeNode node) {
        String ether = node.getText();
        if (ether.equals("O-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMANYL);
        } else if (ether.equals("P-")) {
            this.currentFa.setLipidFaBondType(LipidFaBondType.ETHER_PLASMENYL);
        }
    }

    private void addHydroxyl(TreeNode node) {
        String old_hydroxyl = node.getText();
        int num_h = 0;
        if (old_hydroxyl.equals("m")) {
            num_h = 1;
        } else if (old_hydroxyl.equals("d")) {
            num_h = 2;
        } else if (old_hydroxyl.equals("t")) {
            num_h = 3;
        }
        if (this.spRegularLcb()) {
            --num_h;
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
        functional_group.setCount(num_h);
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
            this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
    }

    private void addOneHydroxyl(TreeNode node) {
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH") && this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).getPosition() == -1) {
            this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).setCount(this.currentFa.getFunctionalGroupsInternal().get("OH").get(0).getCount() + 1);
        } else {
            FunctionalGroup functional_group = this.knownFunctionalGroups.get("OH");
            if (!this.currentFa.getFunctionalGroupsInternal().containsKey("OH")) {
                this.currentFa.getFunctionalGroupsInternal().put("OH", new ArrayList());
            }
            this.currentFa.getFunctionalGroupsInternal().get("OH").add(functional_group);
        }
    }

    private void addSuffixNumber(TreeNode node) {
        this.suffixNumber = node.getInt();
    }

    private void addFaLcbSuffixType(TreeNode node) {
        String suffix_type = node.getText();
        if (suffix_type.equals("me")) {
            suffix_type = "Me";
            this.currentFa.setNumCarbon(this.currentFa.getNumCarbon() - 1);
        }
        FunctionalGroup functional_group = this.knownFunctionalGroups.get(suffix_type);
        functional_group.setPosition(this.suffixNumber);
        if (functional_group.getPosition() == -1) {
            this.setLipidLevel(LipidLevel.STRUCTURE_DEFINED);
        }
        if (!this.currentFa.getFunctionalGroupsInternal().containsKey(suffix_type)) {
            this.currentFa.getFunctionalGroupsInternal().put(suffix_type, new ArrayList());
        }
        this.currentFa.getFunctionalGroupsInternal().get(suffix_type).add(functional_group);
        this.suffixNumber = -1;
    }

    private void addDoubleBonds(TreeNode node) {
        this.currentFa.getDoubleBonds().setNumDoubleBonds(this.currentFa.getDoubleBonds().getNumDoubleBonds() + node.getInt());
    }

    private void addCarbon(TreeNode node) {
        this.currentFa.setNumCarbon(node.getInt());
    }

    private void setSpeciesFa(TreeNode node) {
        this.headGroup = this.headGroup + " 27:1";
        ((FattyAcid)this.faList.get(this.faList.size() - 1)).setNumCarbon(((FattyAcid)this.faList.get(this.faList.size() - 1)).getNumCarbon() - 27);
        ((FattyAcid)this.faList.get(this.faList.size() - 1)).getDoubleBonds().setNumDoubleBonds(((FattyAcid)this.faList.get(this.faList.size() - 1)).getDoubleBonds().getNumDoubleBonds() - 1);
    }

    private void newAdduct(TreeNode node) {
        if (this.adduct == null) {
            this.adduct = new Adduct("", "");
        }
    }

    private void addAdduct(TreeNode node) {
        this.adduct.setAdductString(node.getText());
    }

    private void addCharge(TreeNode node) {
        this.adduct.setCharge(Integer.valueOf(node.getText()));
    }

    private void addChargeSign(TreeNode node) {
        String sign = node.getText();
        if (sign.equals("+")) {
            this.adduct.setChargeSign(1);
        } else if (sign.equals("-")) {
            this.adduct.setChargeSign(-1);
        }
        if (this.adduct.getCharge() == 0) {
            this.adduct.setCharge(1);
        }
    }
}

