/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jmzqc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lifstools.jmzqc.BaseQuality;
import org.lifstools.jmzqc.ControlledVocabulary;
import org.lifstools.jmzqc.QualityMetric;

public record MzQC(String contactAddress, String contactName, List<ControlledVocabulary> controlledVocabularies, OffsetDateTime creationDate, String description, List<BaseQuality> runQualities, List<BaseQuality> setQualities, String version) {
    private final String contactAddress;
    private final String contactName;
    private final List<ControlledVocabulary> controlledVocabularies;
    private final OffsetDateTime creationDate;
    private final String description;
    private final List<BaseQuality> runQualities;
    private final List<BaseQuality> setQualities;
    private final String version;

    public MzQC(String contactAddress, String contactName, List<ControlledVocabulary> controlledVocabularies, OffsetDateTime creationDate, String description, List<BaseQuality> runQualities, List<BaseQuality> setQualities, String version) {
        if (controlledVocabularies == null) {
            controlledVocabularies = Collections.emptyList();
        }
        if (runQualities == null) {
            runQualities = Collections.emptyList();
        }
        if (setQualities == null) {
            setQualities = Collections.emptyList();
        }
        this.contactAddress = contactAddress;
        this.contactName = contactName;
        this.controlledVocabularies = controlledVocabularies;
        this.creationDate = creationDate;
        this.description = description;
        this.runQualities = runQualities;
        this.setQualities = setQualities;
        this.version = version;
    }

    @JsonIgnore
    public List<QualityMetric> getRunQualityMetrics(int index) {
        if (index >= 0 && index < this.runQualities().size()) {
            return ((BaseQuality)this.runQualities().get(index)).qualityMetrics();
        }
        throw new IllegalArgumentException("Can not access run " + index);
    }

    @JsonIgnore
    public List<QualityMetric> getRunQualityMetricsByAccession(int index, String accession) {
        if (index >= 0 && index < this.runQualities().size()) {
            return ((BaseQuality)this.runQualities().get(index)).qualityMetrics().stream().filter(qm -> accession.equals(qm.accession())).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Can not access run " + index);
    }

    public String contactAddress() {
        return this.contactAddress;
    }

    public String contactName() {
        return this.contactName;
    }

    public List<ControlledVocabulary> controlledVocabularies() {
        return this.controlledVocabularies;
    }

    public OffsetDateTime creationDate() {
        return this.creationDate;
    }

    public String description() {
        return this.description;
    }

    public List<BaseQuality> runQualities() {
        return this.runQualities;
    }

    public List<BaseQuality> setQualities() {
        return this.setQualities;
    }

    public String version() {
        return this.version;
    }
}

