/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jmzqc;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Set;
import org.lifstools.jmzqc.Coordinate;
import org.lifstools.jmzqc.MzQC;

/*
 * Exception performing whole class analysis ignored.
 */
public class Converter {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ISO_DATE_TIME).appendOptional(DateTimeFormatter.ISO_OFFSET_DATE_TIME).appendOptional(DateTimeFormatter.ISO_INSTANT).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SX")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ssX")).appendOptional(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).toFormatter().withZone(ZoneOffset.UTC);
    private static final DateTimeFormatter TIME_FORMATTER = new DateTimeFormatterBuilder().appendOptional(DateTimeFormatter.ISO_TIME).appendOptional(DateTimeFormatter.ISO_OFFSET_TIME).parseDefaulting(ChronoField.YEAR, 2020L).parseDefaulting(ChronoField.MONTH_OF_YEAR, 1L).parseDefaulting(ChronoField.DAY_OF_MONTH, 1L).toFormatter().withZone(ZoneOffset.UTC);
    private static ObjectReader reader;
    private static ObjectWriter writer;

    public static OffsetDateTime parseDateTimeString(String str) {
        return ZonedDateTime.from(DATE_TIME_FORMATTER.parse(str)).toOffsetDateTime();
    }

    public static OffsetTime parseTimeString(String str) {
        return ZonedDateTime.from(TIME_FORMATTER.parse(str)).toOffsetDateTime().toOffsetTime();
    }

    public static MzQC of(File file) throws IOException {
        return Converter.of((String)Files.readString(file.toPath(), StandardCharsets.UTF_8));
    }

    public static MzQC of(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            byte[] bytes = in.readAllBytes();
            MzQC mzQC = Converter.of((String)new String(bytes, StandardCharsets.UTF_8));
            return mzQC;
        }
    }

    public static MzQC of(String json) throws IOException {
        return ((Coordinate)Converter.getObjectReader().readValue(json)).mzQC();
    }

    public static Set<ValidationMessage> validate(String json) throws JsonProcessingException {
        return Converter.defaultSchema().validate(Converter.getObjectReader().readTree(json));
    }

    public static Set<ValidationMessage> validate(MzQC mzQc) throws JsonProcessingException {
        return Converter.defaultSchema().validate(Converter.getObjectReader().readTree(Converter.toJsonString((MzQC)mzQc)));
    }

    public static Set<ValidationMessage> validate(File file) throws JsonProcessingException, IOException {
        return Converter.defaultSchema().validate(Converter.getObjectReader().readTree(Files.readString(file.toPath(), StandardCharsets.UTF_8)));
    }

    public static Set<ValidationMessage> validate(URL url) throws JsonProcessingException, IOException {
        try (InputStream is = url.openStream();){
            Set set = Converter.defaultSchema().validate(Converter.getObjectReader().readTree(is));
            return set;
        }
    }

    public static String toJsonString(MzQC obj) throws JsonProcessingException {
        return Converter.getObjectWriter().writeValueAsString((Object)new Coordinate(obj));
    }

    public static File toJsonFile(MzQC obj, File file) throws JsonProcessingException, IOException {
        return Files.writeString(file.toPath(), (CharSequence)Converter.toJsonString((MzQC)obj), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING).toFile();
    }

    private static void instantiateMapper() {
        JsonFactoryBuilder jfb = new JsonFactoryBuilder().enable(JsonReadFeature.ALLOW_TRAILING_COMMA);
        ObjectMapper mapper = new ObjectMapper(jfb.build());
        mapper.findAndRegisterModules();
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new /* Unavailable Anonymous Inner Class!! */);
        mapper.registerModule((Module)module);
        reader = mapper.readerFor(Coordinate.class);
        writer = mapper.writerFor(Coordinate.class);
    }

    private static ObjectReader getObjectReader() {
        if (reader == null) {
            Converter.instantiateMapper();
        }
        return reader;
    }

    private static ObjectWriter getObjectWriter() {
        if (writer == null) {
            Converter.instantiateMapper();
        }
        return writer;
    }

    private static JsonSchema defaultSchema() {
        JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
        SchemaValidatorsConfig config = new SchemaValidatorsConfig();
        config.setHandleNullableField(false);
        return factory.getSchema(Converter.class.getResourceAsStream("/schema/mzqc_schema.json"), config);
    }
}

