/* 
 * Copyright 2021 Nils Hoffmann.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.lifstools.jmzqc;

import java.net.URI;

/**
 * Base element for a term that is defined in a controlled vocabulary, with
 * OPTIONAL value.
 *
 * Type of input file.
 */
public record AnalysisSoftware(
        String accession,
        String description,
        String name,
        Object value,
        URI uri,
        String version) {

}
