/*
 * Decompiled with CFR 0.152.
 */
package org.lifstools.jmzqc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.lifstools.jmzqc.BaseQuality;
import org.lifstools.jmzqc.ControlledVocabulary;
import org.lifstools.jmzqc.QualityMetric;

public record MzQC(String contactAddress, String contactName, List<ControlledVocabulary> controlledVocabularies, OffsetDateTime creationDate, String description, List<BaseQuality> runQualities, List<BaseQuality> setQualities, String version) {
    public MzQC {
        if (controlledVocabularies == null) {
            controlledVocabularies = Collections.emptyList();
        }
        if (runQualities == null) {
            runQualities = Collections.emptyList();
        }
        if (setQualities == null) {
            setQualities = Collections.emptyList();
        }
    }

    @JsonIgnore
    public List<QualityMetric> getRunQualityMetrics(int index) {
        if (index >= 0 && index < this.runQualities().size()) {
            return this.runQualities().get(index).qualityMetrics();
        }
        throw new IllegalArgumentException("Can not access run " + index);
    }

    @JsonIgnore
    public List<QualityMetric> getRunQualityMetricsByAccession(int index, String accession) {
        if (index >= 0 && index < this.runQualities().size()) {
            return this.runQualities().get(index).qualityMetrics().stream().filter(qm -> accession.equals(qm.accession())).collect(Collectors.toList());
        }
        throw new IllegalArgumentException("Can not access run " + index);
    }
}

