/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.resource.plugin;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.transaction.Transactional;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.FeaturePlugin;
import org.ligoj.app.api.ServicePlugin;
import org.ligoj.app.api.SubscriptionMode;
import org.ligoj.app.api.ToolPlugin;
import org.ligoj.app.dao.NodeRepository;
import org.ligoj.app.dao.PluginRepository;
import org.ligoj.app.dao.SubscriptionRepository;
import org.ligoj.app.model.Node;
import org.ligoj.app.model.Plugin;
import org.ligoj.app.model.PluginType;
import org.ligoj.app.resource.node.NodeResource;
import org.ligoj.app.resource.plugin.CurlProcessor;
import org.ligoj.app.resource.plugin.PluginVo;
import org.ligoj.app.resource.plugin.PluginsClassLoader;
import org.ligoj.bootstrap.core.NamedBean;
import org.ligoj.bootstrap.core.SpringUtils;
import org.ligoj.bootstrap.core.dao.csv.CsvForJpa;
import org.ligoj.bootstrap.core.resource.BusinessException;
import org.ligoj.bootstrap.core.resource.TechnicalException;
import org.ligoj.bootstrap.resource.system.configuration.ConfigurationResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Persistable;
import org.springframework.stereotype.Component;

@Path(value="/plugin")
@Component
@Transactional
@Produces(value={"application/json"})
public class PluginResource {
    private static final Logger log = LoggerFactory.getLogger(PluginResource.class);
    private static final String DEFAULT_PLUGIN_URL = "http://central.maven.org/maven2/org/ligoj/plugin/";
    @Autowired
    private NodeRepository nodeRepository;
    @Autowired
    private PluginRepository repository;
    @Autowired
    private SubscriptionRepository subscriptionRepository;
    @Autowired
    protected CsvForJpa csvForJpa;
    @Autowired
    private ConfigurationResource configuration;
    @Autowired
    protected EntityManager em;

    private String getPluginUrl() {
        return StringUtils.appendIfMissing((String)((String)ObjectUtils.defaultIfNull((Object)this.configuration.get("plugins.url"), (Object)DEFAULT_PLUGIN_URL)), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }

    @GET
    public List<PluginVo> findAll() {
        return this.repository.findAll().stream().map(p -> {
            String key = p.getKey();
            PluginVo vo = new PluginVo();
            vo.setId((Serializable)((Object)key));
            FeaturePlugin feature = SpringUtils.getApplicationContext().getBeansOfType(FeaturePlugin.class).values().stream().filter(f -> key.equals(f.getKey())).findFirst().get();
            vo.setName(StringUtils.removeStart((String)feature.getName(), (String)"Ligoj - Plugin "));
            vo.setLocation(this.getPluginLocation(feature).getPath());
            vo.setVendor(feature.getVendor());
            vo.setPlugin(p);
            if (p.getType() != PluginType.FEATURE) {
                vo.setNodes(this.nodeRepository.countByRefined(key));
                vo.setSubscriptions(this.subscriptionRepository.countByNode(key));
                vo.setNode(NodeResource.toVo((Node)((Node)this.nodeRepository.findOne((Serializable)((Object)key)))));
            }
            return vo;
        }).sorted(Comparator.comparing(NamedBean::getId)).collect(Collectors.toList());
    }

    @POST
    @Path(value="{artifact:[\\w-]+}")
    public void install(@PathParam(value="artifact") String artifact) {
        String metaData = StringUtils.defaultString((String)new CurlProcessor().get(this.getPluginUrl() + artifact + "/maven-metadata.xml", new String[0]), (String)"");
        Matcher matcher = Pattern.compile("<latest>([^<]+)</latest>").matcher(metaData);
        if (!matcher.find()) {
            throw new BusinessException(String.format("Versions discovery cannot be performed from from remote server %s for plugin %s", this.getPluginUrl(), artifact), new Serializable[0]);
        }
        this.install(artifact, matcher.group(1));
    }

    @DELETE
    @Path(value="{artifact:[\\w-]+}")
    public void remove(@PathParam(value="artifact") String artifact) throws IOException {
        Files.list(this.getPluginClassLoader().getPluginDirectory()).filter(p -> p.getFileName().toString().matches("^" + artifact + "(-.*)?\\.jar$")).forEach(p -> p.toFile().delete());
        log.info("Plugin {} has been deleted, restart is required", (Object)artifact);
    }

    @POST
    @Path(value="{artifact:[\\w-]+}/{version:[\\w-]+}")
    public void install(@PathParam(value="artifact") String artifact, @PathParam(value="version") String version) {
        String url = this.getPluginUrl() + artifact + "/" + version + "/" + artifact + "-" + version + ".jar";
        java.nio.file.Path target = this.getPluginClassLoader().getPluginDirectory().resolve(artifact + "-" + version + ".jar");
        log.info("Downloading plugin {} v{} from {} to ", new Object[]{artifact, version, url});
        try {
            Files.copy(new URL(url).openStream(), target, StandardCopyOption.REPLACE_EXISTING);
            log.info("Plugin {} v{} has been downloaded, restart is required", (Object)artifact, (Object)version);
        }
        catch (IOException ioe) {
            throw new BusinessException(artifact, new Serializable[]{String.format("Cannot be downloaded from remote server %s", artifact), ioe});
        }
    }

    protected PluginsClassLoader getPluginClassLoader() {
        return (PluginsClassLoader)Thread.currentThread().getContextClassLoader().getParent();
    }

    @EventListener
    public void refreshPlugins(ContextRefreshedEvent event) {
        Map plugins = this.repository.findAll().stream().collect(Collectors.toMap(Plugin::getKey, Function.identity()));
        TreeMap newFeatures = new TreeMap();
        TreeMap<String, FeaturePlugin> updateFeatures = new TreeMap<String, FeaturePlugin>();
        HashSet removedPlugins = new HashSet(plugins.values());
        event.getApplicationContext().getBeansOfType(FeaturePlugin.class).values().stream().forEach(s -> {
            Plugin plugin = (Plugin)plugins.get(s.getKey());
            if (plugin == null) {
                newFeatures.put(s.getKey(), s);
            } else if (!plugin.getVersion().equals(this.getVersion(s))) {
                updateFeatures.put(s.getKey(), (FeaturePlugin)s);
            }
            removedPlugins.remove(plugin);
        });
        updateFeatures.values().stream().forEach(s -> this.configurePluginUpdate(s, (Plugin)plugins.get(s.getKey())));
        newFeatures.values().stream().forEach(arg_0 -> this.configurePluginInstall(arg_0));
        updateFeatures.forEach((k, s) -> s.update(((Plugin)plugins.get(k)).getVersion()));
        newFeatures.values().forEach(FeaturePlugin::install);
        log.info("Plugins are now configured");
        this.repository.deleteAll((Collection)removedPlugins.stream().map(Persistable::getId).collect(Collectors.toList()));
    }

    protected String getLastModifiedTime(FeaturePlugin plugin) throws IOException, URISyntaxException {
        return Files.getLastModifiedTime(Paths.get(plugin.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()), new LinkOption[0]).toString();
    }

    protected void configurePluginUpdate(FeaturePlugin plugin, Plugin entity) {
        String newVersion = this.getVersion(plugin);
        log.info("Updating the plugin {} v{} -> v{}", new Object[]{plugin.getKey(), entity.getVersion(), newVersion});
        entity.setVersion(newVersion);
    }

    protected void configurePluginInstall(FeaturePlugin plugin) {
        String newVersion = this.getVersion(plugin);
        log.info("Installing the new plugin {} v{}", (Object)plugin.getKey(), (Object)newVersion);
        try {
            List installedEntities = plugin.getInstalledEntities();
            Plugin entity = new Plugin();
            if (plugin instanceof ServicePlugin) {
                entity.setType(this.determinePluginType((ServicePlugin)plugin));
                if (!installedEntities.contains(Node.class)) {
                    this.nodeRepository.saveAndFlush((Object)this.newNode((ServicePlugin)plugin));
                }
            } else {
                entity.setType(PluginType.FEATURE);
            }
            this.configurePluginEntities(plugin, installedEntities);
            entity.setKey(plugin.getKey());
            entity.setVersion(newVersion);
            this.repository.saveAndFlush((Object)entity);
        }
        catch (Exception e) {
            log.error("Installing the new plugin {} v{} failed", new Object[]{plugin.getKey(), newVersion, e});
            throw new TechnicalException(String.format("Configuring the new plugin %s failed", plugin.getKey()), (Throwable)e, new Serializable[0]);
        }
    }

    protected PluginType determinePluginType(ServicePlugin plugin) {
        PluginType result;
        PluginType interfaceType = plugin instanceof ToolPlugin ? PluginType.TOOL : PluginType.SERVICE;
        if (interfaceType != (result = PluginType.values()[StringUtils.countMatches((CharSequence)plugin.getKey(), (char)':')])) {
            throw new TechnicalException(String.format("Incompatible type from the key (%s -> %s) vs type from the interface (%s)", plugin.getKey(), result, interfaceType), new Serializable[0]);
        }
        return result;
    }

    protected void configurePluginEntities(FeaturePlugin plugin, List<Class<?>> csvEntities) throws IOException {
        ClassLoader classLoader = plugin.getClass().getClassLoader();
        String pluginLocation = this.getPluginLocation(plugin).toString();
        for (Class<?> entityClass : csvEntities) {
            String csv = "csv/" + StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)entityClass.getSimpleName()), (char)'-').toLowerCase(Locale.ENGLISH) + ".csv";
            this.configurePluginEntity(Collections.list(classLoader.getResources(csv)).stream(), entityClass, pluginLocation);
        }
    }

    protected URL getPluginLocation(FeaturePlugin plugin) {
        return plugin.getClass().getProtectionDomain().getCodeSource().getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configurePluginEntity(Stream<URL> csv, Class<?> entityClass, String pluginLocation) throws IOException {
        InputStreamReader input = null;
        try {
            input = new InputStreamReader(csv.filter(u -> u.getPath().startsWith(pluginLocation) || u.toString().startsWith(pluginLocation)).findFirst().orElseThrow(() -> new TechnicalException(String.format("Unable to find CSV file for entity %s", entityClass.getSimpleName()), new Serializable[0])).openStream(), StandardCharsets.UTF_8);
            this.csvForJpa.toJpa(entityClass, (Reader)input, true, true);
            this.em.flush();
            this.em.clear();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
    }

    protected Node newNode(ServicePlugin service) {
        Node node = new Node();
        node.setId((Serializable)((Object)service.getKey()));
        node.setName(service.getName());
        node.setTag("functional");
        node.setTagUiClasses("fa fa-suitcase");
        node.setMode(SubscriptionMode.LINK);
        node.setUiClasses("$" + service.getName());
        node.setRefined(this.getParentNode(service.getKey()));
        return node;
    }

    protected Node getParentNode(String key) {
        String parentKey = key.substring(0, key.lastIndexOf(58));
        if (parentKey.indexOf(58) == -1) {
            return null;
        }
        return (Node)this.nodeRepository.findOneExpected((Serializable)((Object)parentKey));
    }

    protected String getVersion(FeaturePlugin plugin) {
        return Optional.ofNullable(plugin.getVersion()).orElseGet(() -> {
            try {
                return this.getLastModifiedTime(plugin);
            }
            catch (IOException | URISyntaxException e) {
                log.warn("Unable to determine the version of plug-in {}", plugin.getClass(), (Object)e);
                return "?";
            }
        });
    }
}

