/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.resource.plugin;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.api.PluginException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginsClassLoader
extends URLClassLoader {
    private static final Logger log = LoggerFactory.getLogger(PluginsClassLoader.class);
    public static final String HOME_DIR_PROPERTY = "ligoj.home";
    public static final String HOME_DIR_FOLDER = ".ligoj";
    public static final String PLUGINS_DIR = "plugins";
    public static final String EXPORT_DIR = "export";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(-(\\d+(\\.\\d+){1,3}(-SNAPSHOT)?))\\.jar$");
    private final Path homeDirectory = this.computeHome();
    private Path pluginDirectory = this.homeDirectory.resolve("plugins");

    public PluginsClassLoader() throws IOException {
        super(new URL[0], Thread.currentThread().getContextClassLoader());
        log.info("Initialize the plug-ins from directory from {}", (Object)this.homeDirectory);
        Files.createDirectories(this.pluginDirectory, new FileAttribute[0]);
        this.addURL(this.homeDirectory.toUri().toURL());
        HashMap versionFileToPath = new HashMap();
        TreeMap versionFiles = new TreeMap();
        Files.list(this.pluginDirectory).filter(p -> p.toString().endsWith(".jar")).forEach(path -> this.addVersionFile(versionFileToPath, versionFiles, path));
        TreeMap mostRecentPlugins = new TreeMap(Comparator.reverseOrder());
        versionFiles.keySet().stream().sorted(Comparator.reverseOrder()).filter(p -> !mostRecentPlugins.containsKey(versionFiles.get(p))).forEach(p -> mostRecentPlugins.put(versionFiles.get(p), p));
        for (String versionFile : mostRecentPlugins.values()) {
            URI uri = ((Path)versionFileToPath.get(versionFile)).toUri();
            log.debug("Add plugin {}", (Object)uri);
            this.copyExportedResources((String)versionFiles.get(versionFile), (Path)versionFileToPath.get(versionFile), uri);
        }
        log.info("Plugins ClassLoader has added {} plug-ins and ignored {} old plug-ins", (Object)mostRecentPlugins.size(), (Object)(versionFiles.size() - mostRecentPlugins.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyExportedResources(String plugin, Path pluginFile, URI uri) throws IOException {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.newFileSystem(pluginFile, (ClassLoader)this);
            Path export = fileSystem.getPath("/export", new String[0]);
            if (Files.exists(export, new LinkOption[0])) {
                Path targetExport = this.getHomeDirectory().resolve(EXPORT_DIR);
                Files.walk(export, new FileVisitOption[0]).forEach(from -> this.copyExportedResource(plugin, targetExport, export, from));
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)fileSystem);
        }
        this.addURL(uri.toURL());
    }

    private void copyExportedResource(String plugin, Path targetExport, Path root, Path from) {
        Path dest = targetExport.resolve(root.relativize(from).toString());
        if (!dest.toFile().exists()) {
            try {
                this.copy(from, dest);
            }
            catch (IOException e) {
                throw new PluginException(plugin, String.format("Unable to copy exported resource %s to %s", from, dest.toString()), (Throwable)e);
            }
        }
    }

    protected void copy(Path from, Path dest) throws IOException {
        if (Files.isDirectory(from, new LinkOption[0])) {
            Files.createDirectories(dest, new FileAttribute[0]);
        } else {
            Files.copy(from, dest, new CopyOption[0]);
        }
    }

    private void addVersionFile(Map<String, Path> versionFileToPath, Map<String, String> versionFiles, Path path) {
        String fileWithExtVersion;
        String noVersionFile;
        String file = path.getFileName().toString();
        Matcher matcher = VERSION_PATTERN.matcher(file);
        if (matcher.find()) {
            noVersionFile = file.substring(0, matcher.start());
            fileWithExtVersion = noVersionFile + "-" + this.toExtendedVersion(matcher.group(1));
        } else {
            noVersionFile = FilenameUtils.removeExtension((String)file);
            fileWithExtVersion = noVersionFile + "-0";
        }
        versionFileToPath.put(fileWithExtVersion, path);
        versionFiles.put(fileWithExtVersion, noVersionFile);
    }

    private String toExtendedVersion(String version) {
        StringBuilder fileWithVersionExp = new StringBuilder();
        String[] versionFragments = StringUtils.split((String)version, (String)"-.");
        String[] allFragments = new String[]{"0", "0", "0", "0"};
        System.arraycopy(versionFragments, 0, allFragments, 0, versionFragments.length);
        Arrays.stream(allFragments).map(s -> StringUtils.leftPad((String)StringUtils.leftPad((String)s, (int)7, (char)'0'), (int)8, (char)'Z')).forEach(fileWithVersionExp::append);
        return fileWithVersionExp.toString();
    }

    protected Path computeHome() {
        Path homeDir;
        if (System.getProperty(HOME_DIR_PROPERTY) == null) {
            homeDir = Paths.get(System.getProperty("user.home"), HOME_DIR_FOLDER);
            log.info("Home directory is '{}', resolved from current home user location. Use '{}' system property to override this path", (Object)homeDir, (Object)HOME_DIR_PROPERTY);
        } else {
            homeDir = Paths.get(System.getProperty(HOME_DIR_PROPERTY), new String[0]);
            log.info("Home directory is '{}', resolved from the system property '{}'", (Object)homeDir, (Object)HOME_DIR_PROPERTY);
        }
        return homeDir;
    }

    public Path getHomeDirectory() {
        return this.homeDirectory;
    }

    public Path getPluginDirectory() {
        return this.pluginDirectory;
    }
}

