/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.resource.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class WebjarsServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(WebjarsServlet.class.getName());
    private static final long serialVersionUID = 2461047578940577569L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String webjarsResourceURI = "META-INF/resources" + request.getRequestURI().replaceFirst(request.getContextPath(), "");
        log.fine("Webjars resource requested: " + webjarsResourceURI);
        if (WebjarsServlet.isDirectoryRequest((String)webjarsResourceURI)) {
            response.sendError(403);
            return;
        }
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(webjarsResourceURI);
        if (inputStream == null) {
            response.sendError(404);
        } else {
            try {
                String filename = this.getFileName(webjarsResourceURI);
                String mimeType = this.getServletContext().getMimeType(filename);
                if (mimeType == null) {
                    response.setContentType("application/octet-stream");
                } else {
                    response.setContentType(mimeType);
                }
                IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
            }
            finally {
                inputStream.close();
            }
        }
    }

    private static boolean isDirectoryRequest(String uri) {
        return uri.endsWith("/");
    }

    private String getFileName(String webjarsResourceURI) {
        String[] tokens = webjarsResourceURI.split("/");
        return tokens[tokens.length - 1];
    }
}

