/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.resource.security;

import javax.transaction.Transactional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.ligoj.app.iam.IAuthenticationContributor;
import org.ligoj.app.iam.IamProvider;
import org.ligoj.app.resource.security.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Path(value="/security")
@Service
@Transactional
@Produces(value={"application/json"})
public class SecurityResource {
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected IamProvider[] iamProvider;

    @POST
    @Path(value="login")
    @Consumes(value={"application/json"})
    public Response login(User user) {
        Authentication authentication = this.authenticate(user.getName(), user.getPassword());
        Response.ResponseBuilder response = Response.noContent();
        this.applicationContext.getBeansOfType(IAuthenticationContributor.class).values().forEach(l -> l.accept(response, authentication));
        return response.build();
    }

    private Authentication authenticate(String name, String credential) {
        return this.iamProvider[0].authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)name, (Object)credential));
    }
}

