/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.boot.web;

import com.samaxes.filter.CacheFilter;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlets.DoSFilter;
import org.ligoj.app.http.proxy.HtmlProxyFilter;
import org.ligoj.app.http.security.CaptchaFilter;
import org.ligoj.app.http.security.CaptchaServlet;
import org.ligoj.bootstrap.http.proxy.BackendProxyServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.web.servlet.ErrorPage;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;

@SpringBootApplication
@ImportResource(value={"classpath:/META-INF/spring/application.xml"})
public class Application
extends SpringBootServletInitializer {
    private static final String SERVICE_PASSWORD_RECOVERY = "/rest/service/password/recovery/*";
    private static final String SERVICE_PASSWORD_RESET = "/rest/service/password/reset/*";
    @Value(value="${ligoj.endpoint.management.url:http://localhost:8081/ligoj-api/manage}")
    private String endpointManagement;
    @Value(value="${ligoj.endpoint.api.url:http://localhost:8081/ligoj-api/rest}")
    private String endpointApi;
    @Value(value="${ligoj.endpoint.plugins.url:http://localhost:8081/ligoj-api/webjars}")
    private String endpointPlugin;
    @Value(value="${app-env:auto}")
    protected String environmentCode;

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class});
    }

    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public ServletRegistrationBean managementServlet() {
        System.setProperty("ligoj.endpoint.managment.url", this.endpointManagement);
        return this.newBackend("managementProxy", "ligoj.endpoint.managment.url", "/manage", new String[]{"/manage/*"});
    }

    @Bean
    public ServletRegistrationBean apiProxyServlet() {
        System.setProperty("ligoj.endpoint.api.url", this.endpointApi);
        return this.newBackend("apiProxy", "ligoj.endpoint.api.url", "/rest", new String[]{"/rest/*"});
    }

    @Bean
    public ServletRegistrationBean pluginProxyServlet() {
        System.setProperty("ligoj.endpoint.plugins.url", this.endpointPlugin);
        return this.newBackend("pluginProxy", "ligoj.endpoint.plugins.url", "/main", new String[]{"/main/service/*", "/main/id/*", "/main/inbox/*"});
    }

    private ServletRegistrationBean newBackend(String name, String proxyToKey, String prefix, String ... mapping) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("proxyToKey", proxyToKey);
        initParameters.put("prefix", prefix);
        initParameters.put("idleTimeout", "120000");
        initParameters.put("maxThreads", "50");
        initParameters.put("timeout", "0");
        initParameters.put("apiKeyParameter", "api-key");
        initParameters.put("apiKeyHeader", "x-api-key");
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)new BackendProxyServlet(), mapping);
        registrationBean.setInitParameters(initParameters);
        registrationBean.setName(name);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean captchaServlet() {
        return new ServletRegistrationBean((Servlet)new CaptchaServlet(), new String[]{"/captcha.png"});
    }

    @Bean
    public FilterRegistrationBean securityFilterChainRegistration() {
        DelegatingFilterProxy filter = new DelegatingFilterProxy();
        filter.setTargetBeanName("springSecurityFilterChain");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setName("springSecurityFilterChain");
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean characterEncodingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CharacterEncodingFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{"*.html", "*.js", "/"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("encoding", "UTF-8");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(5);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean htmlProxyFilter() {
        HtmlProxyFilter proxyFilter = new HtmlProxyFilter();
        proxyFilter.setSuffix(this.getEnvironment());
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)proxyFilter, new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{"/index.html", "/", "/login.html"});
        registrationBean.setOrder(10);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean cacheFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CacheFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{SERVICE_PASSWORD_RESET, SERVICE_PASSWORD_RECOVERY});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("privacy", "public");
        initParameters.put("static", "true");
        initParameters.put("expiration", "31556926");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(15);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean doSFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new DoSFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{SERVICE_PASSWORD_RESET, SERVICE_PASSWORD_RECOVERY, "/captcha.png"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("maxRequestsPerSec", "6");
        initParameters.put("delayMs", "-1");
        initParameters.put("maxWaitMs", "1");
        initParameters.put("throttledRequests", "6");
        initParameters.put("throttleMs", "1000");
        initParameters.put("maxRequestMs", "2000");
        initParameters.put("maxIdleTrackerMs", "5000");
        initParameters.put("trackSessions", "true");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(20);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean captchaFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CaptchaFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{SERVICE_PASSWORD_RESET, SERVICE_PASSWORD_RECOVERY});
        registrationBean.setOrder(100);
        return registrationBean;
    }

    protected String getEnvironment() {
        if (this.environmentCode.equals("auto")) {
            if (System.getProperty("java.class.path", "").contains(".war")) {
                return "-prod";
            }
            return "";
        }
        return this.environmentCode;
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public EmbeddedServletContainerCustomizer containerCustomizer() {
        return container -> container.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500.html"), new ErrorPage(HttpStatus.UNAUTHORIZED, "/403.html"), new ErrorPage(HttpStatus.FORBIDDEN, "/403.html"), new ErrorPage(HttpStatus.NOT_FOUND, "/404.html"), new ErrorPage(HttpStatus.METHOD_NOT_ALLOWED, "/404.html"), new ErrorPage(HttpStatus.SERVICE_UNAVAILABLE, "/503.html")});
    }
}

