/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.proxy;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class HtmlProxyFilter
extends OncePerRequestFilter {
    private String suffix = "";

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        response.setHeader("X-UA-Compatible", "IE=edge");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Expires", "0");
        String baseName = this.getBaseName((ServletRequest)request);
        request.getRequestDispatcher("/" + baseName + this.getOptimizedSuffix(baseName) + ".html").forward((ServletRequest)request, (ServletResponse)response);
    }

    private String getBaseName(ServletRequest request) {
        String servletPath = ((HttpServletRequest)request).getServletPath();
        String base = StringUtils.removeStart((String)servletPath, (String)"/");
        return this.getBaseName(base.isEmpty() ? "index.html" : base);
    }

    private String getBaseName(String servletPath) {
        return FilenameUtils.removeExtension((String)servletPath);
    }

    private String getOptimizedSuffix(String baseName) {
        if ("index".equals(baseName) || "login".equals(baseName)) {
            return this.suffix;
        }
        return "";
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }
}

