/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;

public class DigestAuthenticationFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger log = LoggerFactory.getLogger(DigestAuthenticationFilter.class);
    private String ssoPostUrl;

    public DigestAuthenticationFilter() {
        super("/oauth");
        this.setAuthenticationManager(authentication -> authentication);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getParameter("token");
        if (token != null) {
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("ignoreCookies").build());
            CloseableHttpClient httpClient = clientBuilder.build();
            try {
                HttpPost httpPost = new HttpPost(this.getSsoPostUrl());
                httpPost.setEntity((HttpEntity)new StringEntity(token, StandardCharsets.UTF_8.name()));
                httpPost.setHeader("Content-Type", "application/json");
                CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
                if (200 == httpResponse.getStatusLine().getStatusCode()) {
                    Authentication authentication = this.getAuthenticationManager().authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)EntityUtils.toString((HttpEntity)httpResponse.getEntity()), (Object)"N/A", new ArrayList()));
                    return authentication;
                }
            }
            catch (IOException e) {
                log.warn("Local SSO server is not available", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((Closeable)httpClient);
            }
        }
        throw new BadCredentialsException("Invalid user or password");
    }

    public void setSsoPostUrl(String ssoPostUrl) {
        this.ssoPostUrl = ssoPostUrl;
    }

    public String getSsoPostUrl() {
        return this.ssoPostUrl;
    }
}

