/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import cn.apiclub.captcha.Captcha;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(CaptchaFilter.class);
    public static final String CAPTCHA_HEADER = "captcha";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Captcha captcha;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpSession session = httpServletRequest.getSession(false);
        Captcha captcha2 = captcha = session == null ? null : (Captcha)session.getAttribute("simpleCaptcha");
        if (captcha == null) {
            log.info("No configured for this session");
            this.fail(response, "session", "null");
        } else {
            session.removeAttribute("simpleCaptcha");
            if (captcha.isCorrect(StringUtils.trimToEmpty((String)httpServletRequest.getHeader(CAPTCHA_HEADER)))) {
                chain.doFilter(request, response);
            } else {
                log.info("Invalid captcha received from {} '{}' instead of {}", new Object[]{httpServletRequest.getRemoteHost(), request.getParameter(CAPTCHA_HEADER), captcha.getAnswer()});
                this.fail(response, CAPTCHA_HEADER, "invalid");
            }
        }
    }

    private void fail(ServletResponse response, String key, String value) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setStatus(400);
        httpResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        httpResponse.setContentType("application/json");
        httpResponse.getOutputStream().write(String.format("{\"errors\":{\"%s\":\"%s\"}}", key, value).getBytes(StandardCharsets.UTF_8));
    }

    public void destroy() {
    }
}

