/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.boot.web;

import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.Filter;
import org.ligoj.app.http.security.AbstractAuthenticationProvider;
import org.ligoj.app.http.security.DigestAuthenticationFilter;
import org.ligoj.app.http.security.SimpleUserDetailsService;
import org.ligoj.bootstrap.http.security.ExtendedSecurityExpressionHandler;
import org.ligoj.bootstrap.http.security.RedirectAuthenticationEntryPoint;
import org.ligoj.bootstrap.http.security.RestRedirectStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(jsr250Enabled=true, securedEnabled=true, prePostEnabled=true)
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Value(value="${security.max-sessions:1}")
    private int maxSession;
    @Value(value="${security:Rest}")
    private String security;
    @Value(value="${sso.url}")
    private String ssoUrl;
    @Value(value="${sso.content}")
    private String ssoContent;
    @Value(value="${ligoj.endpoint.api.url}")
    private String apiEndpoint;
    @Autowired
    private ExtendedSecurityExpressionHandler expressionHandler;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().expressionHandler((SecurityExpressionHandler)this.expressionHandler).antMatchers(HttpMethod.POST, new String[]{"/login"})).permitAll().regexMatchers(HttpMethod.GET, new String[]{"/(\\d+|themes|lib|dist|login|main/public).*"})).permitAll().antMatchers(new String[]{"/rest/redirect", "/rest/security/login", "/captcha.png"})).permitAll().antMatchers(new String[]{"/rest/security/login"})).anonymous().antMatchers(new String[]{"/rest/service/password/reset/**", "/rest/service/password/recovery/**"})).anonymous().anyRequest()).access("hasParameter('api-key') or hasHeader('x-api-key') or isFullyAuthenticated()").and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.ajaxFormLoginEntryPoint()).accessDeniedPage("/login.html?denied").and()).logout().invalidateHttpSession(true).logoutSuccessUrl("/login.html?logout").and()).formLogin().loginPage("/login.html?denied").loginProcessingUrl("/login")).successHandler((AuthenticationSuccessHandler)this.getSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.getFailureHandler())).and()).csrf().disable()).sessionManagement().sessionAuthenticationStrategy((SessionAuthenticationStrategy)this.sessionAuth()).and()).securityContext().and()).addFilterAt((Filter)this.digestAuthenticationFilter(), org.springframework.security.web.authentication.www.DigestAuthenticationFilter.class).addFilterAfter((Filter)this.concurrentSessionFilter(), ConcurrentSessionFilter.class);
    }

    @Bean
    public ConcurrentSessionFilter concurrentSessionFilter() {
        return new ConcurrentSessionFilter(this.sessionRegistry(), (SessionInformationExpiredStrategy)new SimpleRedirectSessionInformationExpiredStrategy("/login.html?concurrency"));
    }

    @Bean
    public DigestAuthenticationFilter digestAuthenticationFilter() {
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setSsoPostUrl(this.apiEndpoint + "/security/sso");
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl("/login.html");
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)failureHandler);
        SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("target");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
        return filter;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler getFailureHandler() {
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler();
        RestRedirectStrategy strategy = this.getRestFailureStrategy();
        handler.setRedirectStrategy((RedirectStrategy)strategy);
        handler.setDefaultFailureUrl("/");
        return handler;
    }

    @Bean
    public RestRedirectStrategy getRestFailureStrategy() {
        RestRedirectStrategy strategy = new RestRedirectStrategy();
        strategy.setSuccess(false);
        strategy.setStatus(401);
        return strategy;
    }

    @Bean
    public SimpleUrlAuthenticationSuccessHandler getSuccessHandler() {
        SimpleUrlAuthenticationSuccessHandler handler = new SimpleUrlAuthenticationSuccessHandler();
        RestRedirectStrategy strategy = new RestRedirectStrategy();
        strategy.setSuccess(true);
        handler.setRedirectStrategy((RedirectStrategy)strategy);
        return handler;
    }

    @Bean
    public CompositeSessionAuthenticationStrategy sessionAuth() {
        SessionRegistry registry = this.sessionRegistry();
        ConcurrentSessionControlAuthenticationStrategy sas = new ConcurrentSessionControlAuthenticationStrategy(registry);
        sas.setMaximumSessions(this.maxSession);
        sas.setExceptionIfMaximumExceeded(false);
        SessionFixationProtectionStrategy sfps = new SessionFixationProtectionStrategy();
        RegisterSessionAuthenticationStrategy rsas = new RegisterSessionAuthenticationStrategy(registry);
        return new CompositeSessionAuthenticationStrategy(Arrays.asList(sas, sfps, rsas));
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws Exception {
        auth.eraseCredentials(true).authenticationProvider((AuthenticationProvider)this.authenticationProvider());
    }

    @Bean
    public RedirectAuthenticationEntryPoint ajaxFormLoginEntryPoint() {
        RedirectAuthenticationEntryPoint ep = new RedirectAuthenticationEntryPoint("/login.html");
        ep.setRedirectUrls(new HashSet<String>(Arrays.asList("/", "index.html", "index-prod.html", "login.html", "login-prod.html")));
        ep.setRedirectStrategy((RedirectStrategy)this.getRestFailureStrategy());
        return ep;
    }

    @Bean
    public AbstractAuthenticationProvider authenticationProvider() throws Exception {
        AbstractAuthenticationProvider provider = (AbstractAuthenticationProvider)Class.forName("org.ligoj.app.http.security." + this.security + "AuthenticationProvider").getConstructors()[0].newInstance(new Object[0]);
        provider.setSsoPostUrl(this.ssoUrl);
        provider.setSsoPostUrl(this.ssoContent);
        return provider;
    }

    @Bean
    public SimpleUserDetailsService userDetailsServiceBean() {
        return new SimpleUserDetailsService();
    }

    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        return firewall;
    }

    public void configure(WebSecurity web) throws Exception {
        web.httpFirewall(this.allowUrlEncodedSlashHttpFirewall());
    }
}

