/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.ligoj.app.http.security.AbstractAuthenticationProvider;
import org.ligoj.bootstrap.http.security.CookieUsernamePasswordAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;

public class RestAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationProvider.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Authentication authenticate(Authentication authentication) {
        String userpassword = StringUtils.defaultString((String)authentication.getCredentials().toString(), (String)"");
        String userName = StringUtils.lowerCase((String)authentication.getPrincipal().toString());
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        HttpPost httpPost = new HttpPost(this.getSsoPostUrl());
        try (CloseableHttpClient httpClient = clientBuilder.build();){
            String content = String.format(this.getSsoPostContent(), userName, userpassword);
            httpPost.setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8));
            httpPost.setHeader("Content-Type", "application/json");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (204 == httpResponse.getStatusLine().getStatusCode()) {
                Authentication authentication2 = this.newAuthentication(userName, userpassword, authentication, (HttpResponse)httpResponse);
                return authentication2;
            }
            log.info("Failed authentication of {}[{}] : {}", new Object[]{userName, userpassword.length(), httpResponse.getStatusLine().getStatusCode()});
            httpResponse.getEntity().getContent().close();
            throw new BadCredentialsException("Invalid user or password");
        }
        catch (IOException e) {
            log.warn("Remote SSO server is not available", (Throwable)e);
        }
        throw new BadCredentialsException("Invalid user or password");
    }

    private Authentication newAuthentication(String userName, String userpassword, Authentication authentication, HttpResponse httpResponse) {
        List cookies = Arrays.stream(httpResponse.getAllHeaders()).filter(header -> "set-cookie".equals(header.getName())).map(NameValuePair::getValue).collect(Collectors.toList());
        String realUserName = Optional.ofNullable(httpResponse.getFirstHeader("X-Real-User")).map(NameValuePair::getValue).orElse(userName);
        if (realUserName.equals(userName)) {
            log.info("Success authentication of {}[{}]", new Object[]{realUserName, userpassword.length(), realUserName});
        } else {
            log.info("Success authentication of {}[{}] using login {}", new Object[]{realUserName, userpassword.length(), userName});
        }
        return new CookieUsernamePasswordAuthenticationToken((Object)realUserName, authentication.getCredentials(), authentication.getAuthorities(), cookies);
    }
}

