/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedCredentialsNotFoundException;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;

public class SilentRequestHeaderAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    private String principalHeaderCopy;

    public SilentRequestHeaderAuthenticationFilter() {
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler();
        handler.setDefaultFailureUrl("/401.html");
        handler.setUseForward(true);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)handler);
        this.setExceptionIfHeaderMissing(false);
        this.setCheckForPrincipalChanges(false);
        this.setContinueFilterChainOnUnsuccessfulAuthentication(false);
    }

    public void setPrincipalRequestHeader(String principalRequestHeader) {
        super.setPrincipalRequestHeader(principalRequestHeader);
        this.principalHeaderCopy = principalRequestHeader;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        if (req.getRequestURI().matches(".*/([0-9]{3}\\.html|favicon.ico|themes/.*)")) {
            chain.doFilter(request, response);
        } else {
            String principal = (String)this.getPreAuthenticatedPrincipal(req);
            if (principal == null || this.getPreAuthenticatedCredentials(req) == null) {
                this.unsuccessfulAuthentication(req, res, (AuthenticationException)new PreAuthenticatedCredentialsNotFoundException(this.principalHeaderCopy + " header not found in request."));
            } else if (req.getRequestURI().matches(req.getContextPath() + "/?login.html")) {
                res.sendRedirect(StringUtils.appendIfMissing((String)req.getContextPath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            } else {
                super.doFilter(request, response, chain);
            }
        }
    }
}

