/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.boot.web;

import com.samaxes.filter.CacheFilter;
import java.util.HashMap;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlets.DoSFilter;
import org.ligoj.app.http.proxy.HtmlProxyFilter;
import org.ligoj.app.http.security.CaptchaFilter;
import org.ligoj.app.http.security.CaptchaServlet;
import org.ligoj.bootstrap.http.proxy.BackendProxyServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.ErrorPageRegistrar;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportResource;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.session.HttpSessionEventPublisher;
import org.springframework.web.context.request.RequestContextListener;
import org.springframework.web.filter.CharacterEncodingFilter;
import org.springframework.web.filter.DelegatingFilterProxy;

@SpringBootApplication
@ImportResource(value={"classpath:/META-INF/spring/application.xml"})
@EnableAutoConfiguration
public class Application
extends SpringBootServletInitializer {
    private static final String SERVICE_RECOVERY = "/rest/service/password/recovery/*";
    private static final String SERVICE_RESET = "/rest/service/password/reset/*";
    @Value(value="${ligoj.endpoint.manage.url:http://localhost:8081/ligoj-api/manage}")
    private String endpointManagement;
    @Value(value="${ligoj.endpoint.api.url:http://localhost:8081/ligoj-api/rest}")
    private String endpointApi;
    @Value(value="${ligoj.endpoint.plugins.url:http://localhost:8081/ligoj-api/webjars}")
    private String endpointPlugin;
    @Value(value="${app-env:auto}")
    protected String environmentCode;
    protected static ConfigurableApplicationContext lastContext;

    protected SpringApplicationBuilder configure(SpringApplicationBuilder application) {
        return application.sources(new Class[]{Application.class});
    }

    public static void main(String[] args) {
        lastContext = SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public ServletRegistrationBean<BackendProxyServlet> managementServlet() {
        System.setProperty("ligoj.endpoint.manage.url", this.endpointManagement);
        return this.newBackend("managementProxy", "ligoj.endpoint.manage.url", "/manage", new String[]{"/manage/*"});
    }

    @Bean
    public ServletRegistrationBean<BackendProxyServlet> apiProxyServlet() {
        System.setProperty("ligoj.endpoint.api.url", this.endpointApi);
        return this.newBackend("apiProxy", "ligoj.endpoint.api.url", "/rest", new String[]{"/rest/*"});
    }

    @Bean
    public ServletRegistrationBean<BackendProxyServlet> pluginProxyServlet() {
        System.setProperty("ligoj.endpoint.plugins.url", this.endpointPlugin);
        return this.newBackend("pluginProxy", "ligoj.endpoint.plugins.url", "/main", new String[]{"/main/*"});
    }

    private ServletRegistrationBean<BackendProxyServlet> newBackend(String name, String proxyToKey, String prefix, String ... mapping) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("proxyToKey", proxyToKey);
        initParameters.put("prefix", prefix);
        initParameters.put("idleTimeout", "120000");
        initParameters.put("maxThreads", "50");
        initParameters.put("timeout", "0");
        initParameters.put("apiKeyParameter", "api-key");
        initParameters.put("apiKeyHeader", "x-api-key");
        ServletRegistrationBean registrationBean = new ServletRegistrationBean((Servlet)new BackendProxyServlet(), mapping);
        registrationBean.setInitParameters(initParameters);
        registrationBean.setName(name);
        return registrationBean;
    }

    @Bean
    public ServletRegistrationBean<CaptchaServlet> captchaServlet() {
        return new ServletRegistrationBean((Servlet)new CaptchaServlet(), new String[]{"/captcha.png"});
    }

    @Bean
    public FilterRegistrationBean<DelegatingFilterProxy> securityFilterChainRegistration() {
        DelegatingFilterProxy filter = new DelegatingFilterProxy();
        filter.setTargetBeanName("springSecurityFilterChain");
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)filter, new ServletRegistrationBean[0]);
        registrationBean.setName("springSecurityFilterChain");
        registrationBean.addUrlPatterns(new String[]{"/*"});
        registrationBean.setOrder(1);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<CharacterEncodingFilter> characterEncodingFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CharacterEncodingFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{"*.html", "*.js", "/"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("encoding", "UTF-8");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(5);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<HtmlProxyFilter> htmlProxyFilter() {
        HtmlProxyFilter proxyFilter = new HtmlProxyFilter();
        proxyFilter.setSuffix(this.getEnvironment());
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)proxyFilter, new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{"/index.html", "/", "/login.html"});
        registrationBean.setOrder(10);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<CacheFilter> cacheFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CacheFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{"/dist/*", "/img/*", "/main/*", "/themes/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("privacy", "public");
        initParameters.put("static", "true");
        initParameters.put("expiration", "31556926");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(15);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<DoSFilter> doSFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new DoSFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{SERVICE_RESET, SERVICE_RECOVERY, "/captcha.png"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("maxRequestsPerSec", "6");
        initParameters.put("delayMs", "-1");
        initParameters.put("maxWaitMs", "1");
        initParameters.put("throttledRequests", "6");
        initParameters.put("throttleMs", "1000");
        initParameters.put("maxRequestMs", "2000");
        initParameters.put("maxIdleTrackerMs", "5000");
        initParameters.put("trackSessions", "true");
        registrationBean.setInitParameters(initParameters);
        registrationBean.setOrder(20);
        return registrationBean;
    }

    @Bean
    public FilterRegistrationBean<CaptchaFilter> captchaFilter() {
        FilterRegistrationBean registrationBean = new FilterRegistrationBean((Filter)new CaptchaFilter(), new ServletRegistrationBean[0]);
        registrationBean.addUrlPatterns(new String[]{SERVICE_RESET, SERVICE_RECOVERY});
        registrationBean.setOrder(100);
        return registrationBean;
    }

    protected String getEnvironment() {
        if ("auto".equals(this.environmentCode)) {
            if (System.getProperty("java.class.path", "").contains(".war")) {
                return "-prod";
            }
            return "";
        }
        return this.environmentCode;
    }

    @Bean
    public RequestContextListener requestContextListener() {
        return new RequestContextListener();
    }

    @Bean
    public HttpSessionEventPublisher httpSessionEventPublisher() {
        return new HttpSessionEventPublisher();
    }

    @Bean
    public ErrorPageRegistrar containerCustomizer() {
        return registry -> registry.addErrorPages(new ErrorPage[]{new ErrorPage(HttpStatus.INTERNAL_SERVER_ERROR, "/500.html"), new ErrorPage(HttpStatus.UNAUTHORIZED, "/403.html"), new ErrorPage(HttpStatus.FORBIDDEN, "/403.html"), new ErrorPage(HttpStatus.NOT_FOUND, "/404.html"), new ErrorPage(HttpStatus.METHOD_NOT_ALLOWED, "/404.html"), new ErrorPage(HttpStatus.SERVICE_UNAVAILABLE, "/503.html")});
    }
}

