/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.boot.web;

import java.util.Arrays;
import java.util.HashSet;
import javax.servlet.Filter;
import org.apache.commons.lang3.StringUtils;
import org.ligoj.app.http.security.AbstractAuthenticationProvider;
import org.ligoj.app.http.security.CookieWipingLogoutHandler;
import org.ligoj.app.http.security.DigestAuthenticationFilter;
import org.ligoj.app.http.security.SilentRequestHeaderAuthenticationFilter;
import org.ligoj.app.http.security.SimpleUserDetailsService;
import org.ligoj.bootstrap.http.security.ExtendedSecurityExpressionHandler;
import org.ligoj.bootstrap.http.security.RedirectAuthenticationEntryPoint;
import org.ligoj.bootstrap.http.security.RestRedirectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.http.HttpMethod;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.firewall.DefaultHttpFirewall;
import org.springframework.security.web.firewall.HttpFirewall;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(jsr250Enabled=true, securedEnabled=true, prePostEnabled=true)
@Profile(value={"prod"})
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    private static final Logger log = LoggerFactory.getLogger(SecurityConfiguration.class);
    @Value(value="${security.max-sessions:1}")
    private int maxSession;
    @Value(value="${security:Rest}")
    private String securityProvider;
    @Value(value="${security.pre-auth-principal:}")
    protected String securityPreAuthPrincipal;
    @Value(value="${security.pre-auth-logout:}")
    protected String securityPreAuthLogout;
    @Value(value="${security.pre-auth-credentials:}")
    protected String securityPreAuthCredentials;
    @Value(value="${security.pre-auth-cookies:}")
    protected String[] securityPreAuthCookies;
    @Value(value="${sso.url}")
    private String ssoUrl;
    @Value(value="${sso.content}")
    private String ssoContent;
    @Value(value="${ligoj.endpoint.api.url}")
    private String apiEndpoint;
    @Autowired
    private ExtendedSecurityExpressionHandler expressionHandler;

    @Bean
    public RedirectAuthenticationEntryPoint ajaxFormLoginEntryPoint() {
        RedirectAuthenticationEntryPoint ep = new RedirectAuthenticationEntryPoint("/login.html");
        ep.setRedirectUrls(new HashSet<String>(Arrays.asList("/", "index.html", "index-prod.html", "login.html", "login-prod.html")));
        ep.setRedirectStrategy((RedirectStrategy)this.getRestFailureStrategy());
        return ep;
    }

    @Bean
    public HttpFirewall allowUrlEncodedSlashHttpFirewall() {
        DefaultHttpFirewall firewall = new DefaultHttpFirewall();
        firewall.setAllowUrlEncodedSlash(true);
        return firewall;
    }

    @Bean
    public AbstractAuthenticationProvider authenticationProvider() throws ReflectiveOperationException {
        AbstractAuthenticationProvider provider = (AbstractAuthenticationProvider)Class.forName("org.ligoj.app.http.security." + this.securityProvider + "AuthenticationProvider").getConstructors()[0].newInstance(new Object[0]);
        provider.setSsoPostUrl(this.ssoUrl);
        provider.setSsoPostContent(this.ssoContent);
        return provider;
    }

    @Bean
    public ConcurrentSessionFilter concurrentSessionFilter() {
        return new ConcurrentSessionFilter(this.sessionRegistry(), (SessionInformationExpiredStrategy)new SimpleRedirectSessionInformationExpiredStrategy("/login.html?concurrency"));
    }

    protected void configure(HttpSecurity http) throws Exception {
        String logout = this.isPreAuth() ? (String)StringUtils.defaultIfBlank((CharSequence)this.securityPreAuthLogout, (CharSequence)"/logout.html") : "/login.html?logout";
        HttpSecurity sec = ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)http.authorizeRequests().expressionHandler((SecurityExpressionHandler)this.expressionHandler).antMatchers(HttpMethod.POST, new String[]{"/login"})).permitAll().antMatchers(HttpMethod.GET, new String[]{"/favicon.ico"})).permitAll().regexMatchers(HttpMethod.GET, new String[]{"/([0-9]{3}|themes|lib|dist|login|logout|main/public).*", logout.replace("?", "\\?").replace(".", "\\.")})).permitAll().antMatchers(new String[]{"/rest/redirect", "/rest/security/login", "/captcha.png"})).permitAll().antMatchers(new String[]{"/rest/service/password/reset/**", "/rest/service/password/recovery/**"})).anonymous().anyRequest()).access("hasParameter('api-key') or hasHeader('x-api-key') or isFullyAuthenticated()").and()).exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)this.ajaxFormLoginEntryPoint()).accessDeniedPage("/login.html?denied").and()).logout().addLogoutHandler((LogoutHandler)new CookieWipingLogoutHandler(this.securityPreAuthCookies)).invalidateHttpSession(true).logoutSuccessUrl(logout).and()).formLogin().loginPage("/login.html?denied").loginProcessingUrl("/login")).successHandler((AuthenticationSuccessHandler)this.getSuccessHandler())).failureHandler((AuthenticationFailureHandler)this.getFailureHandler())).and()).csrf().disable()).sessionManagement().sessionAuthenticationStrategy((SessionAuthenticationStrategy)this.sessionAuth()).and()).securityContext().and()).addFilterAt((Filter)this.digestAuthenticationFilter(), org.springframework.security.web.authentication.www.DigestAuthenticationFilter.class).addFilterAfter((Filter)this.concurrentSessionFilter(), ConcurrentSessionFilter.class);
        if (this.isPreAuth()) {
            log.info("Pre-auth filter is enabled with {}/{}, logout: {}", new Object[]{this.securityPreAuthPrincipal, this.securityPreAuthCredentials, logout});
            SilentRequestHeaderAuthenticationFilter bean = new SilentRequestHeaderAuthenticationFilter();
            bean.setPrincipalRequestHeader(this.securityPreAuthPrincipal);
            bean.setCredentialsRequestHeader(this.securityPreAuthCredentials);
            bean.setAuthenticationManager(this.authenticationManager());
            sec.addFilterAt((Filter)bean, AbstractPreAuthenticatedProcessingFilter.class);
        }
    }

    private boolean isPreAuth() {
        return StringUtils.isNotBlank((CharSequence)this.securityPreAuthPrincipal);
    }

    public void configure(WebSecurity web) {
        web.httpFirewall(this.allowUrlEncodedSlashHttpFirewall());
    }

    @Autowired
    public void configureGlobal(AuthenticationManagerBuilder auth) throws ReflectiveOperationException {
        auth.eraseCredentials(true).authenticationProvider((AuthenticationProvider)this.authenticationProvider());
    }

    @Bean
    public DigestAuthenticationFilter digestAuthenticationFilter() {
        DigestAuthenticationFilter filter = new DigestAuthenticationFilter();
        filter.setSsoPostUrl(this.apiEndpoint + "/security/sso");
        SimpleUrlAuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
        failureHandler.setDefaultFailureUrl("/login.html");
        filter.setAuthenticationFailureHandler((AuthenticationFailureHandler)failureHandler);
        SimpleUrlAuthenticationSuccessHandler successHandler = new SimpleUrlAuthenticationSuccessHandler();
        successHandler.setTargetUrlParameter("target");
        filter.setAuthenticationSuccessHandler((AuthenticationSuccessHandler)successHandler);
        return filter;
    }

    @Bean
    public SimpleUrlAuthenticationFailureHandler getFailureHandler() {
        SimpleUrlAuthenticationFailureHandler handler = new SimpleUrlAuthenticationFailureHandler();
        RestRedirectStrategy strategy = this.getRestFailureStrategy();
        handler.setRedirectStrategy((RedirectStrategy)strategy);
        handler.setDefaultFailureUrl("/");
        return handler;
    }

    @Bean
    public RestRedirectStrategy getRestFailureStrategy() {
        RestRedirectStrategy strategy = new RestRedirectStrategy();
        strategy.setSuccess(false);
        strategy.setStatus(401);
        return strategy;
    }

    @Bean
    public SimpleUrlAuthenticationSuccessHandler getSuccessHandler() {
        SimpleUrlAuthenticationSuccessHandler handler = new SimpleUrlAuthenticationSuccessHandler();
        RestRedirectStrategy strategy = new RestRedirectStrategy();
        strategy.setSuccess(true);
        handler.setRedirectStrategy((RedirectStrategy)strategy);
        return handler;
    }

    @Bean
    public CompositeSessionAuthenticationStrategy sessionAuth() {
        SessionRegistry registry = this.sessionRegistry();
        ConcurrentSessionControlAuthenticationStrategy sas = new ConcurrentSessionControlAuthenticationStrategy(registry);
        sas.setMaximumSessions(this.maxSession);
        sas.setExceptionIfMaximumExceeded(false);
        SessionFixationProtectionStrategy sfps = new SessionFixationProtectionStrategy();
        RegisterSessionAuthenticationStrategy rsas = new RegisterSessionAuthenticationStrategy(registry);
        return new CompositeSessionAuthenticationStrategy(Arrays.asList(sas, sfps, rsas));
    }

    @Bean
    public SessionRegistry sessionRegistry() {
        return new SessionRegistryImpl();
    }

    @Bean
    public SimpleUserDetailsService userDetailsServiceBean() {
        return new SimpleUserDetailsService();
    }
}

