/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import java.util.Arrays;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public final class CookieWipingLogoutHandler
implements LogoutHandler {
    private final String[] cookiesToClear;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        Arrays.stream(this.cookiesToClear).forEach(c -> {
            Cookie cookie = new Cookie(c, null);
            cookie.setPath(request.getContextPath() + "/");
            cookie.setMaxAge(0);
            cookie.setHttpOnly(true);
            response.addCookie(cookie);
            Cookie cookie2 = new Cookie(c, null);
            cookie2.setPath("/");
            cookie2.setMaxAge(0);
            cookie2.setHttpOnly(true);
            response.addCookie(cookie2);
        });
    }

    public CookieWipingLogoutHandler(String[] cookiesToClear) {
        this.cookiesToClear = cookiesToClear;
    }
}

