/*
 * Decompiled with CFR 0.152.
 */
package org.ligoj.app.http.security;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.ligoj.app.http.security.AbstractAuthenticationProvider;
import org.ligoj.bootstrap.http.security.CookieUsernamePasswordAuthenticationToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class RestAuthenticationProvider
extends AbstractAuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(RestAuthenticationProvider.class);

    public Authentication authenticate(Authentication authentication) {
        return this.authenticate(StringUtils.lowerCase((String)authentication.getPrincipal().toString()), StringUtils.defaultString((String)authentication.getCredentials().toString(), (String)""), authentication.getAuthorities());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Authentication authenticate(String username, String credential, Collection<? extends GrantedAuthority> authorities) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        HttpPost httpPost = new HttpPost(this.getSsoPostUrl());
        try (CloseableHttpClient httpClient = clientBuilder.build();){
            String content = String.format(this.getSsoPostContent(), username, credential.replace("\\", "\\\\").replace("\"", "\\\""));
            httpPost.setEntity((HttpEntity)new StringEntity(content, StandardCharsets.UTF_8));
            httpPost.setHeader("Content-Type", "application/json");
            CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            if (204 == httpResponse.getStatusLine().getStatusCode()) {
                Authentication authentication = this.newAuthentication(username, credential, authorities, (HttpResponse)httpResponse);
                return authentication;
            }
            log.info("Failed authentication of {}[{}] : {}", new Object[]{username, credential.length(), httpResponse.getStatusLine().getStatusCode()});
            httpResponse.getEntity().getContent().close();
            throw new BadCredentialsException("Invalid user or password");
        }
        catch (IOException e) {
            log.warn("Remote SSO server is not available", (Throwable)e);
        }
        throw new BadCredentialsException("Invalid user or password");
    }

    private Authentication newAuthentication(String username, String credentials, Collection<? extends GrantedAuthority> authorities, HttpResponse httpResponse) {
        List<String> cookies = Arrays.stream(httpResponse.getAllHeaders()).filter(header -> "set-cookie".equals(header.getName())).map(NameValuePair::getValue).toList();
        String realUserName = Optional.ofNullable(httpResponse.getFirstHeader("X-Real-User")).map(NameValuePair::getValue).orElse(username);
        if (realUserName.equals(username)) {
            log.info("Success authentication of {}[{}]", (Object)realUserName, (Object)credentials.length());
        } else {
            log.info("Success authentication of {}[{}] using login {}", new Object[]{realUserName, credentials.length(), username});
        }
        return new CookieUsernamePasswordAuthenticationToken((Object)realUserName, (Object)credentials, authorities, cookies);
    }
}

