/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.KdbxHeader;
import org.linguafranca.pwdb.kdbx.KdbxStreamFormat;
import org.linguafranca.pwdb.kdbx.dom.DomEntryWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomGroupWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.dom.DomIconWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomSerializableDatabase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DomDatabaseWrapper
extends AbstractDatabase<DomDatabaseWrapper, DomGroupWrapper, DomEntryWrapper, DomIconWrapper> {
    private final DomSerializableDatabase domDatabase = DomSerializableDatabase.createEmptyDatabase();
    Element dbMeta;
    private Document document;
    private Element dbRootGroup;
    private StreamFormat<?> streamFormat;

    public DomDatabaseWrapper() {
        this.init();
    }

    public DomDatabaseWrapper(Credentials credentials, InputStream inputStream) throws IOException {
        this.streamFormat = new KdbxStreamFormat();
        this.streamFormat.load((SerializableDatabase)this.domDatabase, credentials, inputStream);
        this.init();
    }

    public static DomDatabaseWrapper load(@NotNull Credentials credentials, @NotNull InputStream inputStream) throws IOException {
        return new DomDatabaseWrapper((Credentials)Preconditions.checkNotNull((Object)credentials, (Object)"Credentials must not be null"), (InputStream)Preconditions.checkNotNull((Object)inputStream, (Object)"InputStream must not be null"));
    }

    private void init() {
        this.document = this.domDatabase.getDoc();
        try {
            this.dbRootGroup = (Element)DomHelper.xpath.evaluate("/KeePassFile/Root/Group", this.document, XPathConstants.NODE);
            this.dbMeta = (Element)DomHelper.xpath.evaluate("/KeePassFile/Meta", this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new IllegalStateException(e);
        }
    }

    public void save(Credentials credentials, OutputStream outputStream) throws IOException {
        if (Objects.isNull(this.streamFormat)) {
            this.streamFormat = new KdbxStreamFormat(new KdbxHeader(4));
        }
        this.save(this.streamFormat, credentials, outputStream);
    }

    public <C extends StreamConfiguration> void save(StreamFormat<C> streamFormat, Credentials credentials, OutputStream outputStream) throws IOException {
        DomHelper.getElement((String)"//Generator", (Element)this.domDatabase.getDoc().getDocumentElement(), (boolean)false).setTextContent("KeePassJava2-DOM");
        streamFormat.save((SerializableDatabase)this.domDatabase, credentials, outputStream);
        this.setDirty(false);
    }

    public boolean shouldProtect(String name) {
        Element protectionElement = DomHelper.getElement((String)("MemoryProtection/Protect" + name), (Element)this.dbMeta, (boolean)false);
        if (protectionElement == null) {
            return false;
        }
        return Boolean.parseBoolean(protectionElement.getTextContent());
    }

    public DomGroupWrapper getRootGroup() {
        return new DomGroupWrapper(this.dbRootGroup, this, false);
    }

    public DomGroupWrapper newGroup() {
        return new DomGroupWrapper(this.document.createElement("Group"), this, true);
    }

    public DomEntryWrapper newEntry() {
        return new DomEntryWrapper(this.document.createElement("Entry"), this, true);
    }

    public DomIconWrapper newIcon() {
        return new DomIconWrapper(this.document.createElement("IconID"));
    }

    public DomIconWrapper newIcon(Integer i) {
        DomIconWrapper icon = this.newIcon();
        icon.setIndex(i);
        return icon;
    }

    public DomGroupWrapper getRecycleBin() {
        UUID uuid;
        String UuidContent = DomHelper.getElementContent((String)"RecycleBinUuid", (Element)this.dbMeta);
        if (UuidContent != null && (uuid = Helpers.uuidFromBase64((String)UuidContent)).getLeastSignificantBits() != 0L && uuid.getMostSignificantBits() != 0L) {
            for (DomGroupWrapper g : this.getRootGroup().getGroups()) {
                if (!g.getUuid().equals(uuid)) continue;
                return g;
            }
        }
        if (!this.isRecycleBinEnabled()) {
            return null;
        }
        DomGroupWrapper g = this.newGroup();
        g.setName("Recycle Bin");
        this.getRootGroup().addGroup(g);
        DomHelper.ensureElementContent((String)"RecycleBinUuid", (Element)this.dbMeta, (String)Helpers.base64FromUuid((UUID)g.getUuid()));
        DomHelper.touchElement((String)"RecycleBinChanged", (Element)this.dbMeta);
        return g;
    }

    public boolean isRecycleBinEnabled() {
        return Boolean.parseBoolean(DomHelper.getElementContent((String)"RecycleBinEnabled", (Element)this.dbMeta));
    }

    public void enableRecycleBin(boolean enable) {
        DomHelper.setElementContent((String)"RecycleBinEnabled", (Element)this.dbMeta, (String)Boolean.valueOf(enable).toString());
    }

    public String getName() {
        return DomHelper.getElementContent((String)"DatabaseName", (Element)this.dbMeta);
    }

    public void setName(String name) {
        DomHelper.setElementContent((String)"DatabaseName", (Element)this.dbMeta, (String)name);
        DomHelper.touchElement((String)"DatabaseNameChanged", (Element)this.dbMeta);
        this.setDirty(true);
    }

    public String getDescription() {
        return DomHelper.getElementContent((String)"DatabaseDescription", (Element)this.dbMeta);
    }

    public void setDescription(String description) {
        DomHelper.setElementContent((String)"DatabaseDescription", (Element)this.dbMeta, (String)description);
        DomHelper.touchElement((String)"DatabaseDescriptionChanged", (Element)this.dbMeta);
        this.setDirty(true);
    }

    public StreamFormat<?> getStreamFormat() {
        return this.streamFormat;
    }
}

