/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.dom;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.linguafranca.pwdb.base.AbstractEntry;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.dom.DomDatabaseWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomGroupWrapper;
import org.linguafranca.pwdb.kdbx.dom.DomHelper;
import org.linguafranca.pwdb.kdbx.dom.DomIconWrapper;
import org.w3c.dom.Element;

public class DomEntryWrapper
extends AbstractEntry<DomDatabaseWrapper, DomGroupWrapper, DomEntryWrapper, DomIconWrapper> {
    private static Map<String, DomHelper.ValueCreator> mandatoryEntryElements = new HashMap<String, DomHelper.ValueCreator>(){
        {
            this.put("UUID", new DomHelper.UuidValueCreator());
            this.put("IconID", new DomHelper.ConstantValueCreator("2"));
            this.put("Times", new DomHelper.ConstantValueCreator(""));
            this.put("Times/LastModificationTime", new DomHelper.DateValueCreator());
            this.put("Times/CreationTime", new DomHelper.DateValueCreator());
            this.put("Times/LastAccessTime", new DomHelper.DateValueCreator());
            this.put("Times/ExpiryTime", new DomHelper.DateValueCreator());
            this.put("Times/Expires", new DomHelper.ConstantValueCreator("False"));
            this.put("Times/UsageCount", new DomHelper.ConstantValueCreator("0"));
            this.put("Times/LocationChanged", new DomHelper.DateValueCreator());
        }
    };
    final Element element;
    private final DomDatabaseWrapper database;

    public DomEntryWrapper(Element element, DomDatabaseWrapper database, boolean newElement) {
        this.element = element;
        this.database = database;
        if (newElement) {
            DomHelper.ensureElements((Element)element, mandatoryEntryElements);
            this.ensureProperty("Notes");
            this.ensureProperty("Title");
            this.ensureProperty("URL");
            this.ensureProperty("UserName");
            this.ensureProperty("Password");
        }
    }

    public String getProperty(String name) {
        Element property = DomHelper.getElement((String)String.format("String[Key/text()='%s']", name), (Element)this.element, (boolean)false);
        if (property == null) {
            return null;
        }
        return DomHelper.getElementContent((String)"Value", (Element)property);
    }

    public void setProperty(String name, String value) {
        Element property = DomHelper.getElement((String)String.format("String[Key/text()='%s']", name), (Element)this.element, (boolean)false);
        if (property == null) {
            property = DomHelper.newElement((String)"String", (Element)this.element);
            DomHelper.setElementContent((String)"Key", (Element)property, (String)name);
        }
        DomHelper.setElementContent((String)"Value", (Element)property, (String)value);
        DomHelper.touchElement((String)"Times/LastModificationTime", (Element)this.element);
        this.database.setDirty(true);
    }

    public boolean removeProperty(String name) throws IllegalArgumentException {
        if (STANDARD_PROPERTY_NAMES.contains(name)) {
            throw new IllegalArgumentException("may not remove property: " + name);
        }
        boolean wasRemoved = DomHelper.removeElement((String)String.format("String[Key/text()='%s']", name), (Element)this.element);
        if (wasRemoved) {
            this.database.setDirty(true);
        }
        return wasRemoved;
    }

    public List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        List list = DomHelper.getElements((String)"String", (Element)this.element);
        for (Element listElement : list) {
            result.add(DomHelper.getElementContent((String)"Key", (Element)listElement));
        }
        return result;
    }

    public byte[] getBinaryProperty(String name) {
        Element property = DomHelper.getElement((String)String.format("Binary[Key/text()='%s']", name), (Element)this.element, (boolean)false);
        if (property == null) {
            return null;
        }
        return DomHelper.getBinaryElementContent((String)"Value", (Element)property);
    }

    public void setBinaryProperty(String name, byte[] value) {
        Element property = DomHelper.getElement((String)String.format("Binary[Key/text()='%s']", name), (Element)this.element, (boolean)false);
        if (property == null) {
            property = DomHelper.newElement((String)"Binary", (Element)this.element);
            DomHelper.setElementContent((String)"Key", (Element)property, (String)name);
        }
        DomHelper.setBinaryElementContent((String)"Value", (Element)property, (byte[])value);
        DomHelper.touchElement((String)"Times/LastModificationTime", (Element)this.element);
        this.database.setDirty(true);
    }

    public boolean removeBinaryProperty(String name) {
        boolean wasRemoved = DomHelper.removeElement((String)String.format("Binary[Key/text()='%s']", name), (Element)this.element);
        if (wasRemoved) {
            this.database.setDirty(true);
        }
        return wasRemoved;
    }

    public List<String> getBinaryPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        List list = DomHelper.getElements((String)"Binary", (Element)this.element);
        for (Element listElement : list) {
            result.add(DomHelper.getElementContent((String)"Key", (Element)listElement));
        }
        return result;
    }

    private void ensureProperty(String name) {
        Element property = DomHelper.getElement((String)String.format("String[Key/text()='%s']", name), (Element)this.element, (boolean)false);
        if (property == null) {
            Element container = DomHelper.newElement((String)"String", (Element)this.element);
            DomHelper.setElementContent((String)"Key", (Element)container, (String)name);
            DomHelper.getElement((String)"Value", (Element)container, (boolean)true);
        }
    }

    public DomGroupWrapper getParent() {
        if (this.element.getParentNode() == null) {
            return null;
        }
        return new DomGroupWrapper((Element)this.element.getParentNode(), this.database, false);
    }

    public UUID getUuid() {
        return Helpers.uuidFromBase64((String)DomHelper.getElementContent((String)"UUID", (Element)this.element));
    }

    public DomIconWrapper getIcon() {
        return new DomIconWrapper(DomHelper.getElement((String)"IconID", (Element)this.element, (boolean)false));
    }

    public void setIcon(DomIconWrapper icon) {
        DomHelper.getElement((String)"IconID", (Element)this.element, (boolean)true).setTextContent(String.valueOf(icon.getIndex()));
        DomHelper.touchElement((String)"Times/LastModificationTime", (Element)this.element);
        this.database.setDirty(true);
    }

    public Date getLastAccessTime() {
        return Helpers.toDate((String)DomHelper.getElementContent((String)"Times/LastAccessTime", (Element)this.element));
    }

    public Date getCreationTime() {
        return Helpers.toDate((String)DomHelper.getElementContent((String)"Times/CreationTime", (Element)this.element));
    }

    public boolean getExpires() {
        String content = DomHelper.getElementContent((String)"Times/Expires", (Element)this.element);
        return content != null && content.equalsIgnoreCase("true");
    }

    public void setExpires(boolean expires) {
        DomHelper.setElementContent((String)"Times/Expires", (Element)this.element, (String)(expires ? "True" : "False"));
    }

    public Date getExpiryTime() {
        return Helpers.toDate((String)DomHelper.getElementContent((String)"Times/ExpiryTime", (Element)this.element));
    }

    public void setExpiryTime(Date expiryTime) throws IllegalArgumentException {
        if (expiryTime == null) {
            throw new IllegalArgumentException("expiryTime may not be null");
        }
        String formatted = Helpers.fromDate((Date)expiryTime);
        DomHelper.setElementContent((String)"Times/ExpiryTime", (Element)this.element, (String)formatted);
    }

    public Date getLastModificationTime() {
        return Helpers.toDate((String)DomHelper.getElementContent((String)"Times/LastModificationTime", (Element)this.element));
    }

    protected void touch() {
        DomHelper.setElementContent((String)"Times/LastModificationTime", (Element)this.element, (String)Helpers.fromDate((Date)new Date()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DomEntryWrapper that = (DomEntryWrapper)((Object)o);
        return this.element.equals(that.element) && ((Object)((Object)this.database)).equals((Object)that.database);
    }
}

