/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.jackson.model.EntryClasses;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class ValueDeserializer
extends StdDeserializer<EntryClasses.StringProperty.Value> {
    private final StreamEncryptor encryptor;

    public ValueDeserializer(StreamEncryptor encryptor) {
        super(ValueDeserializer.class);
        this.encryptor = encryptor;
    }

    public EntryClasses.StringProperty.Value deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        EntryClasses.StringProperty.Value result = new EntryClasses.StringProperty.Value();
        if (node.isTextual()) {
            result.setText(node.textValue());
            return result;
        }
        if (node.isObject()) {
            if (node.has("Protected") && Boolean.TRUE.equals(Helpers.toBoolean((String)node.get("Protected").asText()))) {
                String cipherText;
                if (node.has("") && (cipherText = node.get("").asText()) != null && !cipherText.isEmpty()) {
                    byte[] encrypted = Base64.decodeBase64((byte[])cipherText.getBytes());
                    String decrypted = new String(this.encryptor.decrypt(encrypted), StandardCharsets.UTF_8);
                    result.setText(decrypted);
                    result.setProtectOnOutput(true);
                }
            } else if (node.has("ProtectInMemory")) {
                Boolean protectInMemory = Helpers.toBoolean((String)node.get("ProtectInMemory").asText());
                result.setProtectInMemory(protectInMemory);
                if (node.has("")) {
                    result.setText(node.get("").asText());
                }
            }
        }
        return result;
    }
}

