/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.kdbx.jackson.model.EntryClasses;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class ValueSerializer
extends StdSerializer<EntryClasses.StringProperty.Value> {
    private final StreamEncryptor encryptor;

    public ValueSerializer(StreamEncryptor encryptor) {
        super(ValueSerializer.class, false);
        this.encryptor = encryptor;
    }

    public void serialize(EntryClasses.StringProperty.Value value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        ToXmlGenerator xmlGenerator = (ToXmlGenerator)gen;
        xmlGenerator.writeStartObject();
        String stringToWrite = value.getText();
        if (value.getProtectOnOutput()) {
            xmlGenerator.setNextIsAttribute(true);
            xmlGenerator.writeStringField("Protected", "True");
            String plain = value.getText();
            if (plain == null) {
                plain = "";
            }
            byte[] encrypted = this.encryptor.encrypt(plain.getBytes());
            stringToWrite = new String(Base64.encodeBase64((byte[])encrypted));
        }
        xmlGenerator.setNextIsAttribute(false);
        xmlGenerator.setNextIsUnwrapped(true);
        xmlGenerator.writeStringField("text", stringToWrite);
        xmlGenerator.writeEndObject();
    }
}

