/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Objects;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.jackson.JacksonEntry;
import org.linguafranca.pwdb.kdbx.jackson.JacksonGroup;
import org.linguafranca.pwdb.kdbx.jackson.converter.ValueDeserializer;
import org.linguafranca.pwdb.kdbx.jackson.converter.ValueSerializer;
import org.linguafranca.pwdb.kdbx.jackson.model.KeePassFile;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class JacksonSerializableDatabase
implements SerializableDatabase {
    public static boolean FAIL_ON_UNKNOWN_PROPERTIES = true;
    public KeePassFile keePassFile;
    private StreamEncryptor encryptor;
    private PropertyValue.Strategy propertyValueStrategy = new PropertyValue.Strategy.Default();

    public static KeePassFile createEmptyDatabase() throws IOException {
        InputStream inputStream = JacksonSerializableDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        XmlMapper mapper = new XmlMapper();
        return (KeePassFile)mapper.readValue(inputStream, KeePassFile.class);
    }

    public JacksonSerializableDatabase() {
    }

    public JacksonSerializableDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
    }

    public JacksonSerializableDatabase load(InputStream inputStream) throws IOException {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, FAIL_ON_UNKNOWN_PROPERTIES);
        SimpleModule module = new SimpleModule();
        module.addDeserializer(PropertyValue.class, (JsonDeserializer)new ValueDeserializer(this.encryptor, this.propertyValueStrategy));
        mapper.registerModule((Module)module);
        this.keePassFile = (KeePassFile)mapper.readValue(inputStream, KeePassFile.class);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream outputStream) {
        try {
            SimpleModule module = new SimpleModule();
            module.addSerializer(PropertyValue.class, (JsonSerializer)new ValueSerializer(this.encryptor, this.propertyValueStrategy));
            XmlMapper mapper = (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS, MapperFeature.AUTO_DETECT_FIELDS, MapperFeature.AUTO_DETECT_GETTERS, MapperFeature.AUTO_DETECT_SETTERS, MapperFeature.AUTO_DETECT_IS_GETTERS})).build();
            mapper.registerModule((Module)module);
            mapper.enable(ToXmlGenerator.Feature.WRITE_XML_DECLARATION);
            mapper.enable(SerializationFeature.INDENT_OUTPUT);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            System.setProperty("javax.xml.stream.XMLOutputFactory", "com.ctc.wstx.stax.WstxOutputFactory");
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newFactory();
            xmlOutputFactory.setProperty("com.ctc.wstx.useDoubleQuotesInXmlDecl", true);
            xmlOutputFactory.setProperty("javax.xml.stream.isRepairingNamespaces", false);
            xmlOutputFactory.setProperty("com.ctc.wstx.returnNullForDefaultNamespace", true);
            OutputStreamWriter osw = new OutputStreamWriter(outputStream);
            XMLStreamWriter sw = xmlOutputFactory.createXMLStreamWriter(osw);
            try {
                sw.setPrefix("xml", "http://www.w3.org/XML/1998/namespace");
                mapper.writeValue(sw, (Object)this.keePassFile);
                sw.writeEndDocument();
            }
            finally {
                sw.close();
                osw.close();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] getHeaderHash() {
        return this.keePassFile.meta.headerHash;
    }

    public void setHeaderHash(byte[] hash) {
        this.keePassFile.meta.headerHash = hash;
    }

    public static void addBinary(KeePassFile keePassFile, int index, byte[] payload) {
        KeePassFile.Binary newBin = new KeePassFile.Binary();
        newBin.setId(index);
        newBin.setValue(Helpers.encodeBase64Content((byte[])payload, (boolean)true));
        newBin.setCompressed(true);
        if (keePassFile.meta.binaries == null) {
            keePassFile.createBinaries();
        }
        keePassFile.meta.binaries.add(newBin);
    }

    public byte[] getBinary(int index) {
        KeePassFile.Binary binary = this.keePassFile.meta.binaries.get(index);
        String value = binary.getValue();
        return Helpers.decodeBase64Content((byte[])value.getBytes(), (boolean)binary.getCompressed());
    }

    public int getBinaryCount() {
        if (Objects.isNull(this.keePassFile.meta.binaries)) {
            return 0;
        }
        return this.keePassFile.meta.binaries.size();
    }

    static void fixUp(JacksonGroup parent) {
        for (JacksonGroup group : parent.groups) {
            group.parent = parent;
            group.database = parent.database;
            JacksonSerializableDatabase.fixUp(group);
        }
        for (JacksonEntry entry : parent.entries) {
            entry.database = parent.database;
            entry.parent = parent;
        }
    }

    public StreamEncryptor getEncryption() {
        return this.encryptor;
    }

    public void setEncryption(StreamEncryptor encryption) {
        this.encryptor = encryption;
    }

    public void addBinary(int index, byte[] payload) {
        JacksonSerializableDatabase.addBinary(this.keePassFile, index, payload);
    }

    public PropertyValue.Strategy getPropertyValueStrategy() {
        return this.propertyValueStrategy;
    }

    public void setPropertyValueStrategy(PropertyValue.Strategy propertyValueStrategy) {
        this.propertyValueStrategy = propertyValueStrategy;
    }
}

