/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class ValueDeserializer
extends StdDeserializer<PropertyValue> {
    private final StreamEncryptor encryptor;
    private final PropertyValue.Strategy strategy;

    public ValueDeserializer(StreamEncryptor encryptor, PropertyValue.Strategy strategy) {
        super(ValueDeserializer.class);
        this.encryptor = encryptor;
        this.strategy = strategy;
    }

    public PropertyValue deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        if (node.isTextual()) {
            return this.strategy.newUnprotected().of((CharSequence)node.textValue());
        }
        if (node.isObject()) {
            String cipherText = "";
            if (node.has("")) {
                cipherText = node.get("").asText();
            }
            if (node.has("Protected") && Boolean.TRUE.equals(Helpers.toBoolean((String)node.get("Protected").asText()))) {
                byte[] encrypted = Base64.decodeBase64((byte[])cipherText.getBytes());
                byte[] decrypted = this.encryptor.decrypt(encrypted);
                return this.strategy.newProtected().of(decrypted);
            }
            return this.strategy.newUnprotected().of((CharSequence)cipherText);
        }
        throw new IllegalStateException("Error parsing XML node type is " + node.getClass());
    }
}

